/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type;

import com.datastax.oss.driver.api.core.detach.AttachmentPoint;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.MapType;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultMapType
implements MapType,
Serializable {
    private static final long serialVersionUID = 1L;
    private final DataType keyType;
    private final DataType valueType;
    private final boolean frozen;

    public DefaultMapType(@NonNull DataType keyType, @NonNull DataType valueType, boolean frozen) {
        Preconditions.checkNotNull((Object)keyType);
        Preconditions.checkNotNull((Object)valueType);
        this.keyType = keyType;
        this.valueType = valueType;
        this.frozen = frozen;
    }

    @Override
    @NonNull
    public DataType getKeyType() {
        return this.keyType;
    }

    @Override
    @NonNull
    public DataType getValueType() {
        return this.valueType;
    }

    @Override
    public boolean isFrozen() {
        return this.frozen;
    }

    @Override
    public boolean isDetached() {
        return this.keyType.isDetached() || this.valueType.isDetached();
    }

    @Override
    public void attach(@NonNull AttachmentPoint attachmentPoint) {
        this.keyType.attach(attachmentPoint);
        this.valueType.attach(attachmentPoint);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof MapType) {
            MapType that = (MapType)other;
            return this.keyType.equals(that.getKeyType()) && this.valueType.equals(that.getValueType());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(DefaultMapType.class, this.keyType, this.valueType);
    }

    public String toString() {
        return "Map(" + this.keyType + " => " + this.valueType + ", " + (this.frozen ? "" : "not ") + "frozen)";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Preconditions.checkNotNull((Object)this.keyType);
        Preconditions.checkNotNull((Object)this.valueType);
    }
}

