/*
 * Decompiled with CFR 0.152.
 */
package reactor.rabbitmq;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Delivery;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import reactor.rabbitmq.RabbitFluxException;
import reactor.rabbitmq.Receiver;

public class AcknowledgableDelivery
extends Delivery {
    private final Channel channel;
    private final BiConsumer<Receiver.AcknowledgmentContext, Exception> exceptionHandler;
    private final AtomicBoolean notAckedOrNacked = new AtomicBoolean(true);

    public AcknowledgableDelivery(Delivery delivery, Channel channel, BiConsumer<Receiver.AcknowledgmentContext, Exception> exceptionHandler) {
        super(delivery.getEnvelope(), delivery.getProperties(), delivery.getBody());
        this.channel = channel;
        this.exceptionHandler = exceptionHandler;
    }

    public void ack(boolean multiple) {
        if (this.notAckedOrNacked.getAndSet(false)) {
            try {
                this.basicAck(multiple);
            }
            catch (Exception e) {
                this.retry(e, delivery -> delivery.basicAck(multiple));
            }
        }
    }

    public void ack() {
        this.ack(false);
    }

    public void nack(boolean multiple, boolean requeue) {
        if (this.notAckedOrNacked.getAndSet(false)) {
            try {
                this.basicNack(multiple, requeue);
            }
            catch (Exception e) {
                this.retry(e, delivery -> delivery.basicNack(multiple, requeue));
            }
        }
    }

    public void nack(boolean requeue) {
        this.nack(false, requeue);
    }

    private void basicAck(boolean multiple) {
        try {
            this.channel.basicAck(this.getEnvelope().getDeliveryTag(), multiple);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RabbitFluxException(e);
        }
    }

    private void basicNack(boolean multiple, boolean requeue) {
        try {
            this.channel.basicNack(this.getEnvelope().getDeliveryTag(), multiple, requeue);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RabbitFluxException(e);
        }
    }

    private void retry(Exception e, Consumer<AcknowledgableDelivery> consumer) {
        try {
            this.exceptionHandler.accept(new Receiver.AcknowledgmentContext(this, consumer), e);
        }
        catch (Exception e2) {
            this.notAckedOrNacked.set(true);
            throw e2;
        }
    }
}

