/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra;

import com.google.common.hash.Hashing;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.cassandra.mail.CassandraThreadDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraThreadLookupDAO;
import org.apache.james.mailbox.exception.ThreadNotFoundException;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mailbox.model.ThreadId;
import org.apache.james.mailbox.store.mail.ThreadIdGuessingAlgorithm;
import org.apache.james.mailbox.store.mail.model.MimeMessageId;
import org.apache.james.mailbox.store.mail.model.Subject;
import org.apache.james.mailbox.store.search.SearchUtil;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SynchronousSink;

public class CassandraThreadIdGuessingAlgorithm
implements ThreadIdGuessingAlgorithm {
    private static final boolean DISABLE_THREADS = Boolean.valueOf(System.getProperty("james.mailbox.threads.disable", "false"));
    private final MessageIdManager messageIdManager;
    private final CassandraThreadDAO threadDAO;
    private final CassandraThreadLookupDAO threadLookupDAO;

    @Inject
    public CassandraThreadIdGuessingAlgorithm(MessageIdManager messageIdManager, CassandraThreadDAO threadDAO, CassandraThreadLookupDAO threadLookupDAO) {
        this.messageIdManager = messageIdManager;
        this.threadDAO = threadDAO;
        this.threadLookupDAO = threadLookupDAO;
    }

    public Mono<ThreadId> guessThreadIdReactive(MessageId messageId, Optional<MimeMessageId> mimeMessageId, Optional<MimeMessageId> inReplyTo, Optional<List<MimeMessageId>> references, Optional<Subject> subject, MailboxSession session) {
        Set<Integer> hashMimeMessageIds = this.buildMimeMessageIdSet(mimeMessageId, inReplyTo, references).stream().map(mimeMessageId1 -> Hashing.murmur3_32_fixed().hashBytes(mimeMessageId1.getValue().getBytes()).asInt()).collect(Collectors.toSet());
        Optional<Integer> hashBaseSubject = subject.map(value -> new Subject(SearchUtil.getBaseSubject((String)value.getValue()))).map(subject1 -> Hashing.murmur3_32_fixed().hashBytes(subject1.getValue().getBytes()).asInt());
        return Flux.from(this.threadDAO.selectSome(session.getUser(), hashMimeMessageIds)).filter(pair -> ((Optional)pair.getLeft()).equals(hashBaseSubject)).next().map(Pair::getRight).switchIfEmpty(Mono.just((Object)ThreadId.fromBaseMessageId((MessageId)messageId))).flatMap(threadId -> this.threadDAO.insertSome(session.getUser(), hashMimeMessageIds, messageId, (ThreadId)threadId, hashBaseSubject).then(this.threadLookupDAO.insert(messageId, (ThreadId)threadId, session.getUser(), hashMimeMessageIds)).then(Mono.just((Object)threadId)));
    }

    public Flux<MessageId> getMessageIdsInThread(ThreadId threadId, MailboxSession session) {
        if (DISABLE_THREADS) {
            return Flux.just((Object)threadId.getBaseMessageId());
        }
        BiConsumer<Collection, SynchronousSink> throwIfEmpty = (ids, sink) -> {
            if (ids.isEmpty()) {
                sink.error((Throwable)new ThreadNotFoundException(threadId));
            } else {
                sink.next(ids);
            }
        };
        return this.threadLookupDAO.selectAll(threadId).collectList().handle(throwIfEmpty).flatMapMany(messageIds -> Flux.from((Publisher)this.messageIdManager.getMessagesReactive(messageIds, FetchGroup.MINIMAL, session))).sort(Comparator.comparing(MessageResult::getInternalDate).thenComparing(m -> m.getMessageId().serialize())).map(MessageResult::getMessageId).distinct().switchIfEmpty((Publisher)Mono.error(() -> new ThreadNotFoundException(threadId)));
    }

    private Set<MimeMessageId> buildMimeMessageIdSet(Optional<MimeMessageId> mimeMessageId, Optional<MimeMessageId> inReplyTo, Optional<List<MimeMessageId>> references) {
        HashSet<MimeMessageId> mimeMessageIds = new HashSet<MimeMessageId>();
        mimeMessageId.ifPresent(mimeMessageIds::add);
        inReplyTo.ifPresent(mimeMessageIds::add);
        references.ifPresent(mimeMessageIds::addAll);
        return mimeMessageIds;
    }
}

