/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.quota;

import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.backends.cassandra.components.CassandraQuotaLimitDao;
import org.apache.james.core.Domain;
import org.apache.james.core.quota.QuotaComponent;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaLimit;
import org.apache.james.core.quota.QuotaLimitValue;
import org.apache.james.core.quota.QuotaScope;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.core.quota.QuotaType;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.Limits;
import org.apache.james.mailbox.quota.MaxQuotaManager;
import org.apache.james.mailbox.quota.QuotaChangeNotifier;
import org.apache.james.mailbox.quota.QuotaCodec;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraPerUserMaxQuotaManagerV2
implements MaxQuotaManager {
    private static final String GLOBAL_IDENTIFIER = "global";
    private final CassandraQuotaLimitDao cassandraQuotaLimitDao;
    private final QuotaChangeNotifier quotaChangeNotifier;

    @Inject
    public CassandraPerUserMaxQuotaManagerV2(CassandraQuotaLimitDao cassandraQuotaLimitDao, QuotaChangeNotifier quotaChangeNotifier) {
        this.cassandraQuotaLimitDao = cassandraQuotaLimitDao;
        this.quotaChangeNotifier = quotaChangeNotifier;
    }

    public void setMaxStorage(QuotaRoot quotaRoot, QuotaSizeLimit maxStorageQuota) {
        this.setMaxStorageReactive(quotaRoot, maxStorageQuota).block();
    }

    public Mono<Void> setMaxStorageReactive(QuotaRoot quotaRoot, QuotaSizeLimit maxStorageQuota) {
        return this.cassandraQuotaLimitDao.setQuotaLimit(QuotaLimit.builder().quotaScope(QuotaScope.USER).identifier(quotaRoot.getValue()).quotaComponent(QuotaComponent.MAILBOX).quotaType(QuotaType.SIZE).quotaLimit(QuotaCodec.quotaValueToLong((QuotaLimitValue)maxStorageQuota)).build()).then(Mono.from((Publisher)this.quotaChangeNotifier.notifyUpdate(quotaRoot)));
    }

    public void setMaxMessage(QuotaRoot quotaRoot, QuotaCountLimit maxMessageCount) {
        this.setMaxMessageReactive(quotaRoot, maxMessageCount).block();
    }

    public Mono<Void> setMaxMessageReactive(QuotaRoot quotaRoot, QuotaCountLimit maxMessageCount) {
        return this.cassandraQuotaLimitDao.setQuotaLimit(QuotaLimit.builder().quotaScope(QuotaScope.USER).identifier(quotaRoot.getValue()).quotaComponent(QuotaComponent.MAILBOX).quotaType(QuotaType.COUNT).quotaLimit(QuotaCodec.quotaValueToLong((QuotaLimitValue)maxMessageCount)).build()).then(Mono.from((Publisher)this.quotaChangeNotifier.notifyUpdate(quotaRoot)));
    }

    public void setDomainMaxMessage(Domain domain, QuotaCountLimit count) {
        this.setDomainMaxMessageReactive(domain, count).block();
    }

    public Mono<Void> setDomainMaxMessageReactive(Domain domain, QuotaCountLimit count) {
        return this.cassandraQuotaLimitDao.setQuotaLimit(QuotaLimit.builder().quotaScope(QuotaScope.DOMAIN).identifier(domain.asString()).quotaComponent(QuotaComponent.MAILBOX).quotaType(QuotaType.COUNT).quotaLimit(QuotaCodec.quotaValueToLong((QuotaLimitValue)count)).build()).then(Mono.from((Publisher)this.quotaChangeNotifier.notifyUpdate(domain)));
    }

    public void setDomainMaxStorage(Domain domain, QuotaSizeLimit size) {
        this.setDomainMaxStorageReactive(domain, size).block();
    }

    public Mono<Void> setDomainMaxStorageReactive(Domain domain, QuotaSizeLimit size) {
        return this.cassandraQuotaLimitDao.setQuotaLimit(QuotaLimit.builder().quotaScope(QuotaScope.DOMAIN).identifier(domain.asString()).quotaComponent(QuotaComponent.MAILBOX).quotaType(QuotaType.SIZE).quotaLimit(QuotaCodec.quotaValueToLong((QuotaLimitValue)size)).build()).then(Mono.from((Publisher)this.quotaChangeNotifier.notifyUpdate(domain)));
    }

    public void removeDomainMaxMessage(Domain domain) {
        this.removeDomainMaxMessageReactive(domain).block();
    }

    public Mono<Void> removeDomainMaxMessageReactive(Domain domain) {
        return this.cassandraQuotaLimitDao.deleteQuotaLimit(QuotaLimit.QuotaLimitKey.of((QuotaComponent)QuotaComponent.MAILBOX, (QuotaScope)QuotaScope.DOMAIN, (String)domain.asString(), (QuotaType)QuotaType.COUNT)).then(Mono.from((Publisher)this.quotaChangeNotifier.notifyUpdate(domain)));
    }

    public void removeDomainMaxStorage(Domain domain) {
        this.removeDomainMaxStorageReactive(domain).block();
    }

    public Mono<Void> removeDomainMaxStorageReactive(Domain domain) {
        return this.cassandraQuotaLimitDao.deleteQuotaLimit(QuotaLimit.QuotaLimitKey.of((QuotaComponent)QuotaComponent.MAILBOX, (QuotaScope)QuotaScope.DOMAIN, (String)domain.asString(), (QuotaType)QuotaType.SIZE)).then(Mono.from((Publisher)this.quotaChangeNotifier.notifyUpdate(domain)));
    }

    public Optional<QuotaCountLimit> getDomainMaxMessage(Domain domain) {
        return this.getDomainMaxMessageReactive(domain).blockOptional();
    }

    public Mono<QuotaCountLimit> getDomainMaxMessageReactive(Domain domain) {
        return this.getMaxMessageReactive(QuotaScope.DOMAIN, domain.asString());
    }

    public Optional<QuotaSizeLimit> getDomainMaxStorage(Domain domain) {
        return this.getDomainMaxStorageReactive(domain).blockOptional();
    }

    public Mono<QuotaSizeLimit> getDomainMaxStorageReactive(Domain domain) {
        return this.getMaxStorageReactive(QuotaScope.DOMAIN, domain.asString());
    }

    public void removeMaxMessage(QuotaRoot quotaRoot) {
        this.removeMaxMessageReactive(quotaRoot).block();
    }

    public Mono<Void> removeMaxMessageReactive(QuotaRoot quotaRoot) {
        return this.cassandraQuotaLimitDao.deleteQuotaLimit(QuotaLimit.QuotaLimitKey.of((QuotaComponent)QuotaComponent.MAILBOX, (QuotaScope)QuotaScope.USER, (String)quotaRoot.getValue(), (QuotaType)QuotaType.COUNT)).then(Mono.from((Publisher)this.quotaChangeNotifier.notifyUpdate(quotaRoot)));
    }

    public void removeMaxStorage(QuotaRoot quotaRoot) {
        this.removeMaxStorageReactive(quotaRoot).block();
    }

    public Mono<Void> removeMaxStorageReactive(QuotaRoot quotaRoot) {
        return this.cassandraQuotaLimitDao.deleteQuotaLimit(QuotaLimit.QuotaLimitKey.of((QuotaComponent)QuotaComponent.MAILBOX, (QuotaScope)QuotaScope.USER, (String)quotaRoot.getValue(), (QuotaType)QuotaType.SIZE)).then(Mono.from((Publisher)this.quotaChangeNotifier.notifyUpdate(quotaRoot)));
    }

    public void setGlobalMaxStorage(QuotaSizeLimit globalMaxStorage) {
        this.setGlobalMaxStorageReactive(globalMaxStorage).block();
    }

    public Mono<Void> setGlobalMaxStorageReactive(QuotaSizeLimit globalMaxStorage) {
        return this.cassandraQuotaLimitDao.setQuotaLimit(QuotaLimit.builder().quotaScope(QuotaScope.GLOBAL).identifier(GLOBAL_IDENTIFIER).quotaComponent(QuotaComponent.MAILBOX).quotaType(QuotaType.SIZE).quotaLimit(QuotaCodec.quotaValueToLong((QuotaLimitValue)globalMaxStorage)).build()).then(Mono.from((Publisher)this.quotaChangeNotifier.notifyGlobalUpdate()));
    }

    public void removeGlobalMaxStorage() {
        this.removeGlobalMaxStorageReactive().block();
    }

    public Mono<Void> removeGlobalMaxStorageReactive() {
        return this.cassandraQuotaLimitDao.deleteQuotaLimit(QuotaLimit.QuotaLimitKey.of((QuotaComponent)QuotaComponent.MAILBOX, (QuotaScope)QuotaScope.GLOBAL, (String)GLOBAL_IDENTIFIER, (QuotaType)QuotaType.SIZE)).then(Mono.from((Publisher)this.quotaChangeNotifier.notifyGlobalUpdate()));
    }

    public void setGlobalMaxMessage(QuotaCountLimit globalMaxMessageCount) {
        this.setGlobalMaxMessageReactive(globalMaxMessageCount).block();
    }

    public Mono<Void> setGlobalMaxMessageReactive(QuotaCountLimit globalMaxMessageCount) {
        return this.cassandraQuotaLimitDao.setQuotaLimit(QuotaLimit.builder().quotaScope(QuotaScope.GLOBAL).identifier(GLOBAL_IDENTIFIER).quotaComponent(QuotaComponent.MAILBOX).quotaType(QuotaType.COUNT).quotaLimit(QuotaCodec.quotaValueToLong((QuotaLimitValue)globalMaxMessageCount)).build()).then(Mono.from((Publisher)this.quotaChangeNotifier.notifyGlobalUpdate()));
    }

    public void removeGlobalMaxMessage() {
        this.removeGlobalMaxMessageReactive().block();
    }

    public Mono<Void> removeGlobalMaxMessageReactive() {
        return this.cassandraQuotaLimitDao.deleteQuotaLimit(QuotaLimit.QuotaLimitKey.of((QuotaComponent)QuotaComponent.MAILBOX, (QuotaScope)QuotaScope.GLOBAL, (String)GLOBAL_IDENTIFIER, (QuotaType)QuotaType.COUNT)).then(Mono.from((Publisher)this.quotaChangeNotifier.notifyGlobalUpdate()));
    }

    public Optional<QuotaSizeLimit> getGlobalMaxStorage() {
        return this.getGlobalMaxStorageReactive().blockOptional();
    }

    public Mono<QuotaSizeLimit> getGlobalMaxStorageReactive() {
        return this.getMaxStorageReactive(QuotaScope.GLOBAL, GLOBAL_IDENTIFIER);
    }

    public Optional<QuotaCountLimit> getGlobalMaxMessage() {
        return this.getGlobalMaxMessageReactive().blockOptional();
    }

    public Mono<QuotaCountLimit> getGlobalMaxMessageReactive() {
        return this.getMaxMessageReactive(QuotaScope.GLOBAL, GLOBAL_IDENTIFIER);
    }

    public Map<Quota.Scope, QuotaCountLimit> listMaxMessagesDetails(QuotaRoot quotaRoot) {
        return (Map)this.listMaxMessagesDetailsReactive(quotaRoot).block();
    }

    public Mono<Map<Quota.Scope, QuotaCountLimit>> listMaxMessagesDetailsReactive(QuotaRoot quotaRoot) {
        return Flux.merge((Publisher[])new Publisher[]{this.getMaxMessageReactive(QuotaScope.USER, quotaRoot.getValue()).map(limit -> Pair.of((Object)Quota.Scope.User, (Object)limit)), Mono.justOrEmpty((Optional)quotaRoot.getDomain()).flatMap(domain -> this.getMaxMessageReactive(QuotaScope.DOMAIN, domain.asString())).map(limit -> Pair.of((Object)Quota.Scope.Domain, (Object)limit)), this.getGlobalMaxMessageReactive().map(limit -> Pair.of((Object)Quota.Scope.Global, (Object)limit))}).collect(ImmutableMap.toImmutableMap(Pair::getKey, Pair::getValue));
    }

    public Map<Quota.Scope, QuotaSizeLimit> listMaxStorageDetails(QuotaRoot quotaRoot) {
        return (Map)this.listMaxStorageDetailsReactive(quotaRoot).block();
    }

    public Mono<Map<Quota.Scope, QuotaSizeLimit>> listMaxStorageDetailsReactive(QuotaRoot quotaRoot) {
        return Flux.merge((Publisher[])new Publisher[]{this.getMaxStorageReactive(QuotaScope.USER, quotaRoot.getValue()).map(limit -> Pair.of((Object)Quota.Scope.User, (Object)limit)), Mono.justOrEmpty((Optional)quotaRoot.getDomain()).flatMap(domain -> this.getMaxStorageReactive(QuotaScope.DOMAIN, domain.asString())).map(limit -> Pair.of((Object)Quota.Scope.Domain, (Object)limit)), this.getGlobalMaxStorageReactive().map(limit -> Pair.of((Object)Quota.Scope.Global, (Object)limit))}).collect(ImmutableMap.toImmutableMap(Pair::getKey, Pair::getValue));
    }

    public MaxQuotaManager.QuotaDetails quotaDetails(QuotaRoot quotaRoot) {
        return (MaxQuotaManager.QuotaDetails)this.quotaDetailsReactive(quotaRoot).block();
    }

    public Mono<MaxQuotaManager.QuotaDetails> quotaDetailsReactive(QuotaRoot quotaRoot) {
        return Mono.zip(this.getLimits(QuotaScope.USER, quotaRoot.getValue()), (Mono)Mono.justOrEmpty((Optional)quotaRoot.getDomain()).flatMap(domain -> this.getLimits(QuotaScope.DOMAIN, domain.asString())).switchIfEmpty(Mono.just((Object)Limits.empty())), this.getLimits(QuotaScope.GLOBAL, GLOBAL_IDENTIFIER)).map(tuple -> new MaxQuotaManager.QuotaDetails(this.countDetails((Limits)tuple.getT1(), (Limits)tuple.getT2(), ((Limits)tuple.getT3()).getCountLimit()), this.sizeDetails((Limits)tuple.getT1(), (Limits)tuple.getT2(), ((Limits)tuple.getT3()).getSizeLimit())));
    }

    private Mono<Limits> getLimits(QuotaScope quotaScope, String identifier) {
        return this.cassandraQuotaLimitDao.getQuotaLimits(QuotaComponent.MAILBOX, quotaScope, identifier).collectList().map(list -> {
            Map<QuotaType, Optional> map = list.stream().collect(Collectors.toMap(QuotaLimit::getQuotaType, QuotaLimit::getQuotaLimit));
            return new Limits(map.getOrDefault(QuotaType.SIZE, Optional.empty()).flatMap(QuotaCodec::longToQuotaSize), map.getOrDefault(QuotaType.COUNT, Optional.empty()).flatMap(QuotaCodec::longToQuotaCount));
        }).switchIfEmpty(Mono.just((Object)Limits.empty()));
    }

    private Mono<QuotaCountLimit> getMaxMessageReactive(QuotaScope quotaScope, String identifier) {
        return this.cassandraQuotaLimitDao.getQuotaLimit(QuotaLimit.QuotaLimitKey.of((QuotaComponent)QuotaComponent.MAILBOX, (QuotaScope)quotaScope, (String)identifier, (QuotaType)QuotaType.COUNT)).map(QuotaLimit::getQuotaLimit).handle(ReactorUtils.publishIfPresent()).map(QuotaCodec::longToQuotaCount).handle(ReactorUtils.publishIfPresent());
    }

    public Mono<QuotaSizeLimit> getMaxStorageReactive(QuotaScope quotaScope, String identifier) {
        return this.cassandraQuotaLimitDao.getQuotaLimit(QuotaLimit.QuotaLimitKey.of((QuotaComponent)QuotaComponent.MAILBOX, (QuotaScope)quotaScope, (String)identifier, (QuotaType)QuotaType.SIZE)).map(QuotaLimit::getQuotaLimit).handle(ReactorUtils.publishIfPresent()).map(QuotaCodec::longToQuotaSize).handle(ReactorUtils.publishIfPresent());
    }

    private Map<Quota.Scope, QuotaSizeLimit> sizeDetails(Limits userLimits, Limits domainLimits, Optional<QuotaSizeLimit> globalLimits) {
        return (Map)Stream.of(userLimits.getSizeLimit().stream().map(limit -> Pair.of((Object)Quota.Scope.User, (Object)limit)), domainLimits.getSizeLimit().stream().map(limit -> Pair.of((Object)Quota.Scope.Domain, (Object)limit)), globalLimits.stream().map(limit -> Pair.of((Object)Quota.Scope.Global, (Object)limit))).flatMap(Function.identity()).collect(ImmutableMap.toImmutableMap(Pair::getKey, Pair::getValue));
    }

    private Map<Quota.Scope, QuotaCountLimit> countDetails(Limits userLimits, Limits domainLimits, Optional<QuotaCountLimit> globalLimits) {
        return (Map)Stream.of(userLimits.getCountLimit().stream().map(limit -> Pair.of((Object)Quota.Scope.User, (Object)limit)), domainLimits.getCountLimit().stream().map(limit -> Pair.of((Object)Quota.Scope.Domain, (Object)limit)), globalLimits.stream().map(limit -> Pair.of((Object)Quota.Scope.Global, (Object)limit))).flatMap(Function.identity()).collect(ImmutableMap.toImmutableMap(Pair::getKey, Pair::getValue));
    }
}

