/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.critical;

import org.apache.activemq.artemis.utils.critical.CriticalAnalyzer;
import org.apache.activemq.artemis.utils.critical.CriticalCloseable;
import org.apache.activemq.artemis.utils.critical.CriticalComponent;
import org.apache.activemq.artemis.utils.critical.CriticalMeasure;
import org.apache.activemq.artemis.utils.critical.EmptyCriticalAnalyzer;

public class CriticalComponentImpl
implements CriticalComponent {
    private final CriticalMeasure[] measures;
    private final CriticalAnalyzer analyzer;

    @Override
    public CriticalAnalyzer getCriticalAnalyzer() {
        return this.analyzer;
    }

    public CriticalComponentImpl(CriticalAnalyzer analyzer, int numberOfPaths) {
        if (analyzer == null) {
            analyzer = EmptyCriticalAnalyzer.getInstance();
        }
        this.analyzer = analyzer;
        if (analyzer.isMeasuring()) {
            this.measures = new CriticalMeasure[numberOfPaths];
            for (int i = 0; i < numberOfPaths; ++i) {
                this.measures[i] = new CriticalMeasure(this, i);
            }
        } else {
            this.measures = null;
        }
    }

    @Override
    public CriticalCloseable measureCritical(int path) {
        if (!this.analyzer.isMeasuring()) {
            return CriticalMeasure.dummyCloseable;
        }
        return this.measures[path].measure();
    }

    @Override
    public boolean checkExpiration(long timeout, boolean reset) {
        for (int i = 0; i < this.measures.length; ++i) {
            if (!this.measures[i].checkExpiration(timeout, reset)) continue;
            return true;
        }
        return false;
    }
}

