/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import org.apache.james.mailbox.exception.AttachmentNotFoundException;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.AttachmentId;
import org.apache.james.mailbox.model.AttachmentMetadata;
import org.apache.james.mailbox.model.MessageAttachmentMetadata;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.ParsedAttachment;
import org.apache.james.mailbox.store.transaction.Mapper;
import org.apache.james.util.ReactorUtils;
import reactor.core.publisher.Mono;

public interface AttachmentMapper
extends Mapper {
    public InputStream loadAttachmentContent(AttachmentId var1) throws AttachmentNotFoundException, IOException;

    default public Mono<InputStream> loadAttachmentContentReactive(AttachmentId attachmentId) {
        return Mono.fromCallable(() -> this.loadAttachmentContent(attachmentId)).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER);
    }

    public AttachmentMetadata getAttachment(AttachmentId var1) throws AttachmentNotFoundException;

    default public Mono<AttachmentMetadata> getAttachmentReactive(AttachmentId attachmentId) {
        return Mono.fromCallable(() -> this.getAttachment(attachmentId)).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER);
    }

    public List<AttachmentMetadata> getAttachments(Collection<AttachmentId> var1);

    public List<MessageAttachmentMetadata> storeAttachments(Collection<ParsedAttachment> var1, MessageId var2) throws MailboxException;

    default public Mono<List<MessageAttachmentMetadata>> storeAttachmentsReactive(Collection<ParsedAttachment> attachments, MessageId ownerMessageId) {
        return Mono.fromCallable(() -> this.storeAttachments(attachments, ownerMessageId)).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER);
    }
}

