/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.managesieve.core;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.james.core.Username;
import org.apache.james.managesieve.api.AuthenticationException;
import org.apache.james.managesieve.api.AuthenticationProcessor;
import org.apache.james.managesieve.api.AuthenticationRequiredException;
import org.apache.james.managesieve.api.ManageSieveException;
import org.apache.james.managesieve.api.Session;
import org.apache.james.managesieve.api.SessionTerminatedException;
import org.apache.james.managesieve.api.SieveParser;
import org.apache.james.managesieve.api.SyntaxException;
import org.apache.james.managesieve.api.UnknownSaslMechanism;
import org.apache.james.managesieve.api.commands.Authenticate;
import org.apache.james.managesieve.api.commands.Capability;
import org.apache.james.managesieve.api.commands.CoreCommands;
import org.apache.james.managesieve.core.PlainAuthenticationProcessor;
import org.apache.james.managesieve.util.ParserUtils;
import org.apache.james.sieverepository.api.ScriptContent;
import org.apache.james.sieverepository.api.ScriptName;
import org.apache.james.sieverepository.api.SieveRepository;
import org.apache.james.sieverepository.api.exception.DuplicateException;
import org.apache.james.sieverepository.api.exception.IsActiveException;
import org.apache.james.sieverepository.api.exception.QuotaExceededException;
import org.apache.james.sieverepository.api.exception.ScriptNotFoundException;
import org.apache.james.sieverepository.api.exception.SieveRepositoryException;
import org.apache.james.sieverepository.api.exception.StorageException;
import org.apache.james.user.api.UsersRepository;

public class CoreProcessor
implements CoreCommands {
    public static final String IMPLEMENTATION_DESCRIPTION = "Apache ManageSieve v1.0";
    public static final String MANAGE_SIEVE_VERSION = "1.0";
    private final SieveRepository sieveRepository;
    private final SieveParser parser;
    private final Map<Capability.Capabilities, String> capabilitiesBase;
    private final Map<Authenticate.SupportedMechanism, AuthenticationProcessor> authenticationProcessorMap;

    @Inject
    public CoreProcessor(SieveRepository repository, UsersRepository usersRepository, SieveParser parser) {
        this.sieveRepository = repository;
        this.parser = parser;
        this.capabilitiesBase = this.precomputedCapabilitiesBase(parser);
        this.authenticationProcessorMap = new HashMap<Authenticate.SupportedMechanism, AuthenticationProcessor>();
        this.authenticationProcessorMap.put(Authenticate.SupportedMechanism.PLAIN, new PlainAuthenticationProcessor(usersRepository));
    }

    @Override
    public String getAdvertisedCapabilities() {
        return this.convertCapabilityMapToString(this.capabilitiesBase) + "\r\n";
    }

    @Override
    public String capability(Session session) {
        return this.convertCapabilityMapToString(this.computeCapabilityMap(session)) + "\r\nOK";
    }

    private String convertCapabilityMapToString(Map<Capability.Capabilities, String> capabilitiesStringMap) {
        return capabilitiesStringMap.entrySet().stream().map(this::computeCapabilityEntryString).collect(Collectors.joining("\r\n"));
    }

    private Map<Capability.Capabilities, String> computeCapabilityMap(Session session) {
        HashMap capabilities = Maps.newHashMap(this.capabilitiesBase);
        if (session.isAuthenticated()) {
            capabilities.put(Capability.Capabilities.OWNER, session.getUser().asString());
        }
        return capabilities;
    }

    private String computeCapabilityEntryString(Map.Entry<Capability.Capabilities, String> entry) {
        return "\"" + entry.getKey().toString() + "\"" + (String)(entry.getValue() == null ? "" : " \"" + entry.getValue() + "\"");
    }

    @Override
    public String checkScript(Session session, String content) {
        return this.handleCommandExecution(() -> {
            this.authenticationCheck(session);
            return this.manageWarnings(this.parser.parse(content));
        }, session);
    }

    private String manageWarnings(List<String> warnings) {
        if (!warnings.isEmpty()) {
            return "OK (WARNINGS) " + warnings.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(" "));
        }
        return "OK";
    }

    @Override
    public String deleteScript(Session session, String name) {
        return this.handleCommandExecution(() -> {
            this.authenticationCheck(session);
            this.sieveRepository.deleteScript(session.getUser(), new ScriptName(name));
            return "OK";
        }, session);
    }

    @Override
    public String getScript(Session session, String name) {
        return this.handleCommandExecution(() -> {
            this.authenticationCheck(session);
            String scriptContent = IOUtils.toString((InputStream)this.sieveRepository.getScript(session.getUser(), new ScriptName(name)), (Charset)StandardCharsets.UTF_8);
            return "{" + scriptContent.length() + "}\r\n" + scriptContent + "\r\nOK";
        }, session);
    }

    @Override
    public String haveSpace(Session session, String name, long size) {
        return this.handleCommandExecution(() -> {
            this.authenticationCheck(session);
            this.sieveRepository.haveSpace(session.getUser(), new ScriptName(name), size);
            return "OK";
        }, session);
    }

    @Override
    public String listScripts(Session session) {
        return this.handleCommandExecution(() -> this.listScriptsInternals(session), session);
    }

    private String listScriptsInternals(Session session) throws AuthenticationRequiredException, StorageException {
        this.authenticationCheck(session);
        String list = this.sieveRepository.listScripts(session.getUser()).stream().map(scriptSummary -> "\"" + scriptSummary.getName().getValue() + "\"" + (scriptSummary.isActive() ? " ACTIVE" : "")).collect(Collectors.joining("\r\n"));
        if (Strings.isNullOrEmpty((String)list)) {
            return "OK";
        }
        return list + "\r\nOK";
    }

    @Override
    public String putScript(Session session, String name, String content) {
        return this.handleCommandExecution(() -> {
            this.authenticationCheck(session);
            this.sieveRepository.putScript(session.getUser(), new ScriptName(name), new ScriptContent(content));
            return this.manageWarnings(this.parser.parse(content));
        }, session);
    }

    @Override
    public String renameScript(Session session, String oldName, String newName) {
        return this.handleCommandExecution(() -> {
            this.authenticationCheck(session);
            this.sieveRepository.renameScript(session.getUser(), new ScriptName(oldName), new ScriptName(newName));
            return "OK";
        }, session);
    }

    @Override
    public String setActive(Session session, String name) {
        return this.handleCommandExecution(() -> {
            this.authenticationCheck(session);
            this.sieveRepository.setActive(session.getUser(), new ScriptName(name));
            return "OK";
        }, session);
    }

    @Override
    public String noop(String tag) {
        if (Strings.isNullOrEmpty((String)tag)) {
            return "OK \"NOOP completed\"";
        }
        return "OK " + this.taggify(tag) + " \"DONE\"";
    }

    @Override
    public String chooseMechanism(Session session, String mechanism) {
        try {
            if (Strings.isNullOrEmpty((String)mechanism)) {
                return "NO ManageSieve syntax is incorrect : You must specify a SASL mechanism as an argument of AUTHENTICATE command";
            }
            String unquotedMechanism = ParserUtils.unquoteFirst(mechanism);
            Authenticate.SupportedMechanism supportedMechanism = Authenticate.SupportedMechanism.retrieveMechanism(unquotedMechanism);
            session.setChoosedAuthenticationMechanism(supportedMechanism);
            session.setState(Session.State.AUTHENTICATION_IN_PROGRESS);
            AuthenticationProcessor authenticationProcessor = this.authenticationProcessorMap.get((Object)supportedMechanism);
            return authenticationProcessor.initialServerResponse(session);
        }
        catch (UnknownSaslMechanism unknownSaslMechanism) {
            return "NO " + unknownSaslMechanism.getMessage();
        }
    }

    @Override
    public String authenticate(Session session, String suppliedData) {
        try {
            Authenticate.SupportedMechanism currentAuthenticationMechanism = session.getChoosedAuthenticationMechanism();
            AuthenticationProcessor authenticationProcessor = this.authenticationProcessorMap.get((Object)currentAuthenticationMechanism);
            Username authenticatedUsername = authenticationProcessor.isAuthenticationSuccesfull(session, suppliedData);
            if (authenticatedUsername != null) {
                session.setUser(authenticatedUsername);
                session.setState(Session.State.AUTHENTICATED);
                return "OK";
            }
            session.setState(Session.State.UNAUTHENTICATED);
            session.setUser(null);
            return "NO authentication failed";
        }
        catch (AuthenticationException e) {
            return "NO Authentication failed with " + String.valueOf(e.getCause().getClass()) + " : " + e.getMessage();
        }
        catch (SyntaxException e) {
            return "NO ManageSieve syntax is incorrect : " + e.getMessage();
        }
    }

    @Override
    public String unauthenticate(Session session) {
        if (session.isAuthenticated()) {
            session.setState(Session.State.UNAUTHENTICATED);
            session.setUser(null);
            return "OK";
        }
        return "NO UNAUTHENTICATE command must be issued in authenticated state";
    }

    @Override
    public void logout() throws SessionTerminatedException {
        throw new SessionTerminatedException();
    }

    @Override
    public String startTLS(Session session) {
        if (session.getState() == Session.State.UNAUTHENTICATED) {
            if (session.isSslEnabled()) {
                return "NO You can't enable two time SSL encryption";
            }
            session.setState(Session.State.SSL_NEGOCIATION);
            return "OK";
        }
        return "NO command STARTTLS is issued in the wrong state. It must be issued as you are unauthenticated";
    }

    private String handleCommandExecution(CommandWrapper commandWrapper, Session session) {
        try {
            return commandWrapper.execute();
        }
        catch (AuthenticationException e) {
            return "NO Authentication failed with " + String.valueOf(e.getCause().getClass()) + " : " + e.getMessage();
        }
        catch (QuotaExceededException ex) {
            return "NO (QUOTA/MAXSIZE) \"Quota exceeded\"";
        }
        catch (AuthenticationRequiredException ex) {
            return "NO";
        }
        catch (DuplicateException ex) {
            return "NO (ALREADYEXISTS) \"A script with that name already exists\"";
        }
        catch (ScriptNotFoundException ex) {
            return "NO (NONEXISTENT) \"There is no script by that name\"";
        }
        catch (IsActiveException ex) {
            return "NO (ACTIVE) \"You may not delete an active script\"";
        }
        catch (StorageException e) {
            return "NO : Storage Exception : " + e.getMessage();
        }
        catch (SyntaxException e) {
            return this.sanitizeString("NO \"Syntax Error: " + e.getMessage() + "\"");
        }
        catch (ManageSieveException e) {
            return this.sanitizeString("NO \"ManageSieveException: " + e.getMessage() + "\"");
        }
        catch (SieveRepositoryException e) {
            return this.sanitizeString("NO \"SieveRepositoryException: " + e.getMessage() + "\"");
        }
        catch (IOException e) {
            return "NO \"" + e.getMessage() + "\"";
        }
    }

    protected void authenticationCheck(Session session) throws AuthenticationRequiredException {
        if (!session.isAuthenticated()) {
            throw new AuthenticationRequiredException();
        }
    }

    private String buildExtensions(SieveParser parser) {
        return Joiner.on((char)' ').join(parser.getExtensions()).trim();
    }

    private String taggify(String tag) {
        String sanitizedTag = ParserUtils.unquote(tag.trim());
        return "(TAG {" + sanitizedTag.length() + "}\r\n" + sanitizedTag + ")";
    }

    private Map<Capability.Capabilities, String> precomputedCapabilitiesBase(SieveParser parser) {
        String extensions = this.buildExtensions(parser);
        HashMap<Capability.Capabilities, String> capabilitiesBase = new HashMap<Capability.Capabilities, String>();
        capabilitiesBase.put(Capability.Capabilities.IMPLEMENTATION, IMPLEMENTATION_DESCRIPTION);
        capabilitiesBase.put(Capability.Capabilities.VERSION, MANAGE_SIEVE_VERSION);
        capabilitiesBase.put(Capability.Capabilities.SASL, this.constructSaslSupportedAuthenticationMechanisms());
        capabilitiesBase.put(Capability.Capabilities.STARTTLS, null);
        if (!extensions.isEmpty()) {
            capabilitiesBase.put(Capability.Capabilities.SIEVE, extensions);
        }
        return capabilitiesBase;
    }

    private String constructSaslSupportedAuthenticationMechanisms() {
        return Joiner.on((char)' ').join((Iterable)Lists.transform(Arrays.asList(Authenticate.SupportedMechanism.values()), Enum::toString));
    }

    private String sanitizeString(String message) {
        return Joiner.on((String)"\r\n").join(Splitter.on((char)'\n').split((CharSequence)message));
    }

    static interface CommandWrapper {
        public String execute() throws ManageSieveException, SieveRepositoryException, IOException;
    }
}

