/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.util.internal;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;

public final class NetworkUtil {
    private static String hostname;
    private static String mac;
    private static String ip;

    private NetworkUtil() {
    }

    public static synchronized String hostname() {
        if (hostname != null) {
            return hostname;
        }
        hostname = System.getenv("HOSTNAME");
        if (hostname != null && !hostname.isEmpty()) {
            return hostname;
        }
        hostname = System.getenv("COMPUTERNAME");
        if (hostname != null && !hostname.isEmpty()) {
            return hostname;
        }
        try {
            hostname = InetAddress.getLocalHost().getHostName();
            if (hostname != null && !hostname.isEmpty()) {
                return hostname;
            }
        }
        catch (UnknownHostException e) {
            return null;
        }
        return null;
    }

    public static synchronized String mac(NetworkInterface nic) {
        if (mac != null) {
            return mac;
        }
        try {
            if (nic != null && nic.getHardwareAddress() != null) {
                byte[] ha = nic.getHardwareAddress();
                CharSequence[] hex = new String[ha.length];
                for (int i = 0; i < ha.length; ++i) {
                    hex[i] = String.format("%02X", ha[i]);
                }
                mac = String.join((CharSequence)"-", hex);
                return mac;
            }
        }
        catch (SocketException e) {
            return null;
        }
        return null;
    }

    public static synchronized String ip(NetworkInterface nic) {
        Enumeration<InetAddress> ips;
        if (ip != null) {
            return ip;
        }
        if (nic != null && (ips = nic.getInetAddresses()).hasMoreElements()) {
            ip = ips.nextElement().getHostAddress();
            return ip;
        }
        return null;
    }

    public static synchronized String getMachineString() {
        NetworkInterface nic = NetworkUtil.nic();
        String hostname = NetworkUtil.hostname();
        String mac = NetworkUtil.mac(nic);
        String ip = NetworkUtil.ip(nic);
        return String.join((CharSequence)" ", hostname, mac, ip);
    }

    public static synchronized NetworkInterface nic() {
        try {
            InetAddress ip = null;
            NetworkInterface nic = null;
            Enumeration<NetworkInterface> enu = null;
            ip = InetAddress.getByName(NetworkUtil.hostname());
            nic = NetworkInterface.getByInetAddress(ip);
            if (NetworkUtil.acceptable(nic)) {
                return nic;
            }
            enu = NetworkInterface.getNetworkInterfaces();
            while (enu.hasMoreElements()) {
                nic = enu.nextElement();
                if (!NetworkUtil.acceptable(nic)) continue;
                return nic;
            }
        }
        catch (SocketException | UnknownHostException e) {
            return null;
        }
        return null;
    }

    private static synchronized boolean acceptable(NetworkInterface nic) {
        try {
            byte[] mac;
            if (nic != null && nic.isUp() && !nic.isLoopback() && !nic.isVirtual() && (mac = nic.getHardwareAddress()) != null && mac.length == 6) {
                return true;
            }
        }
        catch (SocketException e) {
            return false;
        }
        return false;
    }
}

