/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.message.frontend;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.message.frontend.FrontendMessage;
import io.r2dbc.postgresql.message.frontend.FrontendMessageUtils;
import io.r2dbc.postgresql.util.Assert;
import java.util.Objects;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public final class Execute
implements FrontendMessage,
FrontendMessage.DirectEncoder {
    public static final int NO_LIMIT = 0;
    public static final String UNNAMED_PORTAL = "";
    private final String name;
    private final int rows;

    public Execute(String name, int rows) {
        this.name = Assert.requireNonNull(name, "name must not be null");
        this.rows = rows;
    }

    @Override
    public Publisher<ByteBuf> encode(ByteBufAllocator byteBufAllocator) {
        Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
        return Mono.fromSupplier(() -> {
            ByteBuf out = byteBufAllocator.ioBuffer();
            this.encode(out);
            return out;
        });
    }

    @Override
    public void encode(ByteBuf byteBuf) {
        FrontendMessageUtils.writeByte(byteBuf, 69);
        int writerIndex = byteBuf.writerIndex();
        FrontendMessageUtils.writeLengthPlaceholder(byteBuf);
        FrontendMessageUtils.writeCStringUTF8(byteBuf, this.name);
        FrontendMessageUtils.writeInt(byteBuf, this.rows);
        FrontendMessageUtils.writeSize(byteBuf, writerIndex);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Execute that = (Execute)o;
        return this.rows == that.rows && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.rows);
    }

    public String toString() {
        return "Execute{name='" + this.name + '\'' + ", rows=" + this.rows + '}';
    }
}

