/*
 * Decompiled with CFR 0.152.
 */
package reactor.rabbitmq;

import com.rabbitmq.client.AMQP;
import java.util.Arrays;
import reactor.util.annotation.Nullable;

public class OutboundMessage {
    private final String exchange;
    private final String routingKey;
    private final AMQP.BasicProperties properties;
    private final byte[] body;
    private volatile boolean published = false;

    public OutboundMessage(String exchange, String routingKey, byte[] body) {
        this(exchange, routingKey, null, body);
    }

    public OutboundMessage(String exchange, String routingKey, @Nullable AMQP.BasicProperties properties, byte[] body) {
        this.exchange = exchange;
        this.routingKey = routingKey;
        this.properties = properties;
        this.body = body;
    }

    public String getExchange() {
        return this.exchange;
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    @Nullable
    public AMQP.BasicProperties getProperties() {
        return this.properties;
    }

    public byte[] getBody() {
        return this.body;
    }

    public String toString() {
        return "OutboundMessage{exchange='" + this.exchange + '\'' + ", routingKey='" + this.routingKey + '\'' + ", properties=" + this.properties + ", body=" + Arrays.toString(this.body) + '}';
    }

    void published() {
        this.published = true;
    }

    boolean isPublished() {
        return this.published;
    }
}

