/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Optional;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.core.Username;
import org.apache.james.protocols.api.OidcSASLConfiguration;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.hook.AuthHook;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookReturnCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationAuthHook
implements AuthHook {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationAuthHook.class);
    private Multimap<Username, String> accounts = ImmutableListMultimap.of();

    @Inject
    public ConfigurationAuthHook() {
    }

    public void init(Configuration config) throws ConfigurationException {
        HierarchicalConfiguration hierarchicalConfiguration = (HierarchicalConfiguration)config;
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (HierarchicalConfiguration accountNode : hierarchicalConfiguration.configurationAt("accounts").configurationsAt("account")) {
            String username = accountNode.getString("username");
            if (username == null) continue;
            List passwords = accountNode.getList(String.class, "passwords.password");
            passwords.forEach(pw -> builder.put((Object)Username.of((String)username), pw));
        }
        this.accounts = builder.build();
        LOGGER.info("SMTP authentication enabled from configuration for users: {}", this.accounts.keySet().stream().map(Username::asString).collect(ImmutableList.toImmutableList()));
    }

    public HookResult doAuth(SMTPSession session, Username username, String password) {
        Optional<Username> loggedInUser = Optional.ofNullable(this.accounts.get((Object)username)).filter(allowedsPass -> allowedsPass.stream().anyMatch(password::equals)).map(any -> username);
        if (loggedInUser.isPresent()) {
            session.setUsername(loggedInUser.get());
            session.setRelayingAllowed(true);
            return HookResult.builder().hookReturnCode(HookReturnCode.ok()).smtpDescription("Authentication Successful").build();
        }
        return HookResult.DECLINED;
    }

    public HookResult doSasl(SMTPSession session, OidcSASLConfiguration configuration, String initialResponse) {
        throw new NotImplementedException("No support for OATHBEARER so far");
    }
}

