/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.response.error;

import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.response.Error;

public class AlreadyExists
extends Error {
    public final String keyspace;
    public final String table;

    public AlreadyExists(String message, String keyspace, String table) {
        super(9216, message);
        this.keyspace = keyspace;
        this.table = table;
    }

    public static class SubCodec
    extends Error.SubCodec {
        public SubCodec(int protocolVersion) {
            super(9216, protocolVersion);
        }

        @Override
        public <B> void encode(B dest, Message message, PrimitiveCodec<B> encoder) {
            AlreadyExists alreadyExists = (AlreadyExists)message;
            encoder.writeString(alreadyExists.message, dest);
            encoder.writeString(alreadyExists.keyspace, dest);
            encoder.writeString(alreadyExists.table, dest);
        }

        @Override
        public int encodedSize(Message message) {
            AlreadyExists alreadyExists = (AlreadyExists)message;
            return PrimitiveSizes.sizeOfString(alreadyExists.message) + PrimitiveSizes.sizeOfString(alreadyExists.keyspace) + PrimitiveSizes.sizeOfString(alreadyExists.table);
        }

        @Override
        public <B> Message decode(B source, PrimitiveCodec<B> decoder) {
            String message = decoder.readString(source);
            String keyspace = decoder.readString(source);
            String table = decoder.readString(source);
            return new AlreadyExists(message, keyspace, table);
        }
    }
}

