/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.metadata.schema;

import com.datastax.dse.driver.api.core.metadata.schema.DseEdgeMetadata;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public class DefaultDseEdgeMetadata
implements DseEdgeMetadata,
Serializable {
    private static final long serialVersionUID = 1L;
    @NonNull
    private final CqlIdentifier labelName;
    @NonNull
    private final CqlIdentifier fromTable;
    @NonNull
    private final CqlIdentifier fromLabel;
    @NonNull
    private final List<CqlIdentifier> fromPartitionKeyColumns;
    @NonNull
    private final List<CqlIdentifier> fromClusteringColumns;
    @NonNull
    private final CqlIdentifier toTable;
    @NonNull
    private final CqlIdentifier toLabel;
    @NonNull
    private final List<CqlIdentifier> toPartitionKeyColumns;
    @NonNull
    private final List<CqlIdentifier> toClusteringColumns;

    public DefaultDseEdgeMetadata(@NonNull CqlIdentifier labelName, @NonNull CqlIdentifier fromTable, @NonNull CqlIdentifier fromLabel, @NonNull List<CqlIdentifier> fromPartitionKeyColumns, @NonNull List<CqlIdentifier> fromClusteringColumns, @NonNull CqlIdentifier toTable, @NonNull CqlIdentifier toLabel, @NonNull List<CqlIdentifier> toPartitionKeyColumns, @NonNull List<CqlIdentifier> toClusteringColumns) {
        this.labelName = (CqlIdentifier)Preconditions.checkNotNull((Object)labelName);
        this.fromTable = (CqlIdentifier)Preconditions.checkNotNull((Object)fromTable);
        this.fromLabel = (CqlIdentifier)Preconditions.checkNotNull((Object)fromLabel);
        this.fromPartitionKeyColumns = (List)Preconditions.checkNotNull(fromPartitionKeyColumns);
        this.fromClusteringColumns = (List)Preconditions.checkNotNull(fromClusteringColumns);
        this.toTable = (CqlIdentifier)Preconditions.checkNotNull((Object)toTable);
        this.toLabel = (CqlIdentifier)Preconditions.checkNotNull((Object)toLabel);
        this.toPartitionKeyColumns = (List)Preconditions.checkNotNull(toPartitionKeyColumns);
        this.toClusteringColumns = (List)Preconditions.checkNotNull(toClusteringColumns);
    }

    @Override
    @NonNull
    public CqlIdentifier getLabelName() {
        return this.labelName;
    }

    @Override
    @NonNull
    public CqlIdentifier getFromTable() {
        return this.fromTable;
    }

    @Override
    @NonNull
    public CqlIdentifier getFromLabel() {
        return this.fromLabel;
    }

    @Override
    @NonNull
    public List<CqlIdentifier> getFromPartitionKeyColumns() {
        return this.fromPartitionKeyColumns;
    }

    @Override
    @NonNull
    public List<CqlIdentifier> getFromClusteringColumns() {
        return this.fromClusteringColumns;
    }

    @Override
    @NonNull
    public CqlIdentifier getToTable() {
        return this.toTable;
    }

    @Override
    @NonNull
    public CqlIdentifier getToLabel() {
        return this.toLabel;
    }

    @Override
    @NonNull
    public List<CqlIdentifier> getToPartitionKeyColumns() {
        return this.toPartitionKeyColumns;
    }

    @Override
    @NonNull
    public List<CqlIdentifier> getToClusteringColumns() {
        return this.toClusteringColumns;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof DseEdgeMetadata) {
            DseEdgeMetadata that = (DseEdgeMetadata)other;
            return Objects.equals(this.labelName, that.getLabelName()) && Objects.equals(this.fromTable, that.getFromTable()) && Objects.equals(this.fromLabel, that.getFromLabel()) && Objects.equals(this.fromPartitionKeyColumns, that.getFromPartitionKeyColumns()) && Objects.equals(this.fromClusteringColumns, that.getFromClusteringColumns()) && Objects.equals(this.toTable, that.getToTable()) && Objects.equals(this.toLabel, that.getToLabel()) && Objects.equals(this.toPartitionKeyColumns, that.getToPartitionKeyColumns()) && Objects.equals(this.toClusteringColumns, that.getToClusteringColumns());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.labelName, this.fromTable, this.fromLabel, this.fromPartitionKeyColumns, this.fromClusteringColumns, this.toTable, this.toLabel, this.toPartitionKeyColumns, this.toClusteringColumns);
    }
}

