/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.schema.events;

import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.internal.core.metadata.schema.SchemaChangeType;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class KeyspaceChangeEvent {
    public final SchemaChangeType changeType;
    public final KeyspaceMetadata oldKeyspace;
    public final KeyspaceMetadata newKeyspace;

    public static KeyspaceChangeEvent dropped(KeyspaceMetadata oldKeyspace) {
        return new KeyspaceChangeEvent(SchemaChangeType.DROPPED, oldKeyspace, null);
    }

    public static KeyspaceChangeEvent created(KeyspaceMetadata newKeyspace) {
        return new KeyspaceChangeEvent(SchemaChangeType.CREATED, null, newKeyspace);
    }

    public static KeyspaceChangeEvent updated(KeyspaceMetadata oldKeyspace, KeyspaceMetadata newKeyspace) {
        return new KeyspaceChangeEvent(SchemaChangeType.UPDATED, oldKeyspace, newKeyspace);
    }

    private KeyspaceChangeEvent(SchemaChangeType changeType, KeyspaceMetadata oldKeyspace, KeyspaceMetadata newKeyspace) {
        this.changeType = changeType;
        this.oldKeyspace = oldKeyspace;
        this.newKeyspace = newKeyspace;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof KeyspaceChangeEvent) {
            KeyspaceChangeEvent that = (KeyspaceChangeEvent)other;
            return this.changeType == that.changeType && Objects.equals(this.oldKeyspace, that.oldKeyspace) && Objects.equals(this.newKeyspace, that.newKeyspace);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.changeType, this.oldKeyspace, this.newKeyspace});
    }

    public String toString() {
        switch (this.changeType) {
            case CREATED: {
                return String.format("KeyspaceChangeEvent(CREATED %s)", this.newKeyspace.getName());
            }
            case UPDATED: {
                return String.format("KeyspaceChangeEvent(UPDATED %s=>%s)", this.oldKeyspace.getName(), this.newKeyspace.getName());
            }
            case DROPPED: {
                return String.format("KeyspaceChangeEvent(DROPPED %s)", this.oldKeyspace.getName());
            }
        }
        throw new IllegalStateException("Unsupported change type " + (Object)((Object)this.changeType));
    }
}

