/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ml;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ClientConfig
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ClientConfig> {
    @Nullable
    private final Integer connectionTimeout;
    @Nullable
    private final Integer maxConnection;
    @Nullable
    private final Integer maxRetryTimes;
    @Nullable
    private final Integer readTimeout;
    @Nullable
    private final Integer retryBackoffMillis;
    @Nullable
    private final String retryBackoffPolicy;
    @Nullable
    private final Integer retryTimeoutSeconds;
    public static final JsonpDeserializer<ClientConfig> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClientConfig::setupClientConfigDeserializer);

    private ClientConfig(Builder builder) {
        this.connectionTimeout = builder.connectionTimeout;
        this.maxConnection = builder.maxConnection;
        this.maxRetryTimes = builder.maxRetryTimes;
        this.readTimeout = builder.readTimeout;
        this.retryBackoffMillis = builder.retryBackoffMillis;
        this.retryBackoffPolicy = builder.retryBackoffPolicy;
        this.retryTimeoutSeconds = builder.retryTimeoutSeconds;
    }

    public static ClientConfig of(Function<Builder, ObjectBuilder<ClientConfig>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Integer connectionTimeout() {
        return this.connectionTimeout;
    }

    @Nullable
    public final Integer maxConnection() {
        return this.maxConnection;
    }

    @Nullable
    public final Integer maxRetryTimes() {
        return this.maxRetryTimes;
    }

    @Nullable
    public final Integer readTimeout() {
        return this.readTimeout;
    }

    @Nullable
    public final Integer retryBackoffMillis() {
        return this.retryBackoffMillis;
    }

    @Nullable
    public final String retryBackoffPolicy() {
        return this.retryBackoffPolicy;
    }

    @Nullable
    public final Integer retryTimeoutSeconds() {
        return this.retryTimeoutSeconds;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.connectionTimeout != null) {
            generator.writeKey("connection_timeout");
            generator.write(this.connectionTimeout.intValue());
        }
        if (this.maxConnection != null) {
            generator.writeKey("max_connection");
            generator.write(this.maxConnection.intValue());
        }
        if (this.maxRetryTimes != null) {
            generator.writeKey("max_retry_times");
            generator.write(this.maxRetryTimes.intValue());
        }
        if (this.readTimeout != null) {
            generator.writeKey("read_timeout");
            generator.write(this.readTimeout.intValue());
        }
        if (this.retryBackoffMillis != null) {
            generator.writeKey("retry_backoff_millis");
            generator.write(this.retryBackoffMillis.intValue());
        }
        if (this.retryBackoffPolicy != null) {
            generator.writeKey("retry_backoff_policy");
            generator.write(this.retryBackoffPolicy);
        }
        if (this.retryTimeoutSeconds != null) {
            generator.writeKey("retry_timeout_seconds");
            generator.write(this.retryTimeoutSeconds.intValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupClientConfigDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::connectionTimeout, JsonpDeserializer.integerDeserializer(), "connection_timeout");
        op.add(Builder::maxConnection, JsonpDeserializer.integerDeserializer(), "max_connection");
        op.add(Builder::maxRetryTimes, JsonpDeserializer.integerDeserializer(), "max_retry_times");
        op.add(Builder::readTimeout, JsonpDeserializer.integerDeserializer(), "read_timeout");
        op.add(Builder::retryBackoffMillis, JsonpDeserializer.integerDeserializer(), "retry_backoff_millis");
        op.add(Builder::retryBackoffPolicy, JsonpDeserializer.stringDeserializer(), "retry_backoff_policy");
        op.add(Builder::retryTimeoutSeconds, JsonpDeserializer.integerDeserializer(), "retry_timeout_seconds");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.connectionTimeout);
        result = 31 * result + Objects.hashCode(this.maxConnection);
        result = 31 * result + Objects.hashCode(this.maxRetryTimes);
        result = 31 * result + Objects.hashCode(this.readTimeout);
        result = 31 * result + Objects.hashCode(this.retryBackoffMillis);
        result = 31 * result + Objects.hashCode(this.retryBackoffPolicy);
        result = 31 * result + Objects.hashCode(this.retryTimeoutSeconds);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientConfig other = (ClientConfig)o;
        return Objects.equals(this.connectionTimeout, other.connectionTimeout) && Objects.equals(this.maxConnection, other.maxConnection) && Objects.equals(this.maxRetryTimes, other.maxRetryTimes) && Objects.equals(this.readTimeout, other.readTimeout) && Objects.equals(this.retryBackoffMillis, other.retryBackoffMillis) && Objects.equals(this.retryBackoffPolicy, other.retryBackoffPolicy) && Objects.equals(this.retryTimeoutSeconds, other.retryTimeoutSeconds);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ClientConfig> {
        @Nullable
        private Integer connectionTimeout;
        @Nullable
        private Integer maxConnection;
        @Nullable
        private Integer maxRetryTimes;
        @Nullable
        private Integer readTimeout;
        @Nullable
        private Integer retryBackoffMillis;
        @Nullable
        private String retryBackoffPolicy;
        @Nullable
        private Integer retryTimeoutSeconds;

        public Builder() {
        }

        private Builder(ClientConfig o) {
            this.connectionTimeout = o.connectionTimeout;
            this.maxConnection = o.maxConnection;
            this.maxRetryTimes = o.maxRetryTimes;
            this.readTimeout = o.readTimeout;
            this.retryBackoffMillis = o.retryBackoffMillis;
            this.retryBackoffPolicy = o.retryBackoffPolicy;
            this.retryTimeoutSeconds = o.retryTimeoutSeconds;
        }

        private Builder(Builder o) {
            this.connectionTimeout = o.connectionTimeout;
            this.maxConnection = o.maxConnection;
            this.maxRetryTimes = o.maxRetryTimes;
            this.readTimeout = o.readTimeout;
            this.retryBackoffMillis = o.retryBackoffMillis;
            this.retryBackoffPolicy = o.retryBackoffPolicy;
            this.retryTimeoutSeconds = o.retryTimeoutSeconds;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder connectionTimeout(@Nullable Integer value) {
            this.connectionTimeout = value;
            return this;
        }

        @Nonnull
        public final Builder maxConnection(@Nullable Integer value) {
            this.maxConnection = value;
            return this;
        }

        @Nonnull
        public final Builder maxRetryTimes(@Nullable Integer value) {
            this.maxRetryTimes = value;
            return this;
        }

        @Nonnull
        public final Builder readTimeout(@Nullable Integer value) {
            this.readTimeout = value;
            return this;
        }

        @Nonnull
        public final Builder retryBackoffMillis(@Nullable Integer value) {
            this.retryBackoffMillis = value;
            return this;
        }

        @Nonnull
        public final Builder retryBackoffPolicy(@Nullable String value) {
            this.retryBackoffPolicy = value;
            return this;
        }

        @Nonnull
        public final Builder retryTimeoutSeconds(@Nullable Integer value) {
            this.retryTimeoutSeconds = value;
            return this;
        }

        @Override
        @Nonnull
        public ClientConfig build() {
            this._checkSingleUse();
            return new ClientConfig(this);
        }
    }
}

