/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.snapshot;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class SnapshotShardFailure
implements PlainJsonSerializable {
    @Nonnull
    private final String index;
    @Nullable
    private final String nodeId;
    @Nonnull
    private final String reason;
    @Nonnull
    private final String shardId;
    @Nonnull
    private final String status;
    public static final JsonpDeserializer<SnapshotShardFailure> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SnapshotShardFailure::setupSnapshotShardFailureDeserializer);

    private SnapshotShardFailure(Builder builder) {
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.nodeId = builder.nodeId;
        this.reason = ApiTypeHelper.requireNonNull(builder.reason, this, "reason");
        this.shardId = ApiTypeHelper.requireNonNull(builder.shardId, this, "shardId");
        this.status = ApiTypeHelper.requireNonNull(builder.status, this, "status");
    }

    public static SnapshotShardFailure of(Function<Builder, ObjectBuilder<SnapshotShardFailure>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final String index() {
        return this.index;
    }

    @Nullable
    public final String nodeId() {
        return this.nodeId;
    }

    @Nonnull
    public final String reason() {
        return this.reason;
    }

    @Nonnull
    public final String shardId() {
        return this.shardId;
    }

    @Nonnull
    public final String status() {
        return this.status;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("index");
        generator.write(this.index);
        if (this.nodeId != null) {
            generator.writeKey("node_id");
            generator.write(this.nodeId);
        }
        generator.writeKey("reason");
        generator.write(this.reason);
        generator.writeKey("shard_id");
        generator.write(this.shardId);
        generator.writeKey("status");
        generator.write(this.status);
    }

    protected static void setupSnapshotShardFailureDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index");
        op.add(Builder::nodeId, JsonpDeserializer.stringDeserializer(), "node_id");
        op.add(Builder::reason, JsonpDeserializer.stringDeserializer(), "reason");
        op.add(Builder::shardId, JsonpDeserializer.stringDeserializer(), "shard_id");
        op.add(Builder::status, JsonpDeserializer.stringDeserializer(), "status");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.index.hashCode();
        result = 31 * result + Objects.hashCode(this.nodeId);
        result = 31 * result + this.reason.hashCode();
        result = 31 * result + this.shardId.hashCode();
        result = 31 * result + this.status.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotShardFailure other = (SnapshotShardFailure)o;
        return this.index.equals(other.index) && Objects.equals(this.nodeId, other.nodeId) && this.reason.equals(other.reason) && this.shardId.equals(other.shardId) && this.status.equals(other.status);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<SnapshotShardFailure> {
        private String index;
        @Nullable
        private String nodeId;
        private String reason;
        private String shardId;
        private String status;

        @Nonnull
        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        @Nonnull
        public final Builder nodeId(@Nullable String value) {
            this.nodeId = value;
            return this;
        }

        @Nonnull
        public final Builder reason(String value) {
            this.reason = value;
            return this;
        }

        @Nonnull
        public final Builder shardId(String value) {
            this.shardId = value;
            return this;
        }

        @Nonnull
        public final Builder status(String value) {
            this.status = value;
            return this;
        }

        @Override
        @Nonnull
        public SnapshotShardFailure build() {
            this._checkSingleUse();
            return new SnapshotShardFailure(this);
        }
    }
}

