/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.monitors;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.AlarmSeverity;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorAttribute;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorMessages;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@NotExtensible
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public class GaugeMonitorEntry
extends MonitorEntry {
    @NotNull
    static final String GAUGE_MONITOR_OC = "ds-gauge-monitor-entry";
    private static final long serialVersionUID = -6092840651638645538L;
    @Nullable
    private final AlarmSeverity currentSeverity;
    @Nullable
    private final AlarmSeverity previousSeverity;
    @Nullable
    private final Date currentSeverityStartTime;
    @Nullable
    private final Date lastCriticalStateEndTime;
    @Nullable
    private final Date lastCriticalStateStartTime;
    @Nullable
    private final Date lastMajorStateEndTime;
    @Nullable
    private final Date lastMajorStateStartTime;
    @Nullable
    private final Date lastMinorStateEndTime;
    @Nullable
    private final Date lastMinorStateStartTime;
    @Nullable
    private final Date lastNormalStateEndTime;
    @Nullable
    private final Date lastNormalStateStartTime;
    @Nullable
    private final Date lastWarningStateEndTime;
    @Nullable
    private final Date lastWarningStateStartTime;
    @Nullable
    private final Date initTime;
    @Nullable
    private final Date updateTime;
    @NotNull
    private final List<String> errorMessages;
    @Nullable
    private final Long currentSeverityDurationMillis;
    @Nullable
    private final Long lastCriticalStateDurationMillis;
    @Nullable
    private final Long lastMajorStateDurationMillis;
    @Nullable
    private final Long lastMinorStateDurationMillis;
    @Nullable
    private final Long lastNormalStateDurationMillis;
    @Nullable
    private final Long lastWarningStateDurationMillis;
    @Nullable
    private final Long samplesThisInterval;
    @Nullable
    private final Long totalCriticalStateDurationMillis;
    @Nullable
    private final Long totalMajorStateDurationMillis;
    @Nullable
    private final Long totalMinorStateDurationMillis;
    @Nullable
    private final Long totalNormalStateDurationMillis;
    @Nullable
    private final Long totalWarningStateDurationMillis;
    @Nullable
    private final String currentSeverityDurationString;
    @Nullable
    private final String gaugeName = this.getString("gauge-name");
    @Nullable
    private final String lastCriticalStateDurationString;
    @Nullable
    private final String lastMajorStateDurationString;
    @Nullable
    private final String lastMinorStateDurationString;
    @Nullable
    private final String lastNormalStateDurationString;
    @Nullable
    private final String lastWarningStateDurationString;
    @Nullable
    private final String resource = this.getString("resource");
    @Nullable
    private final String resourceType = this.getString("resource-type");
    @Nullable
    private final String summary;
    @Nullable
    private final String totalCriticalStateDurationString;
    @Nullable
    private final String totalMajorStateDurationString;
    @Nullable
    private final String totalMinorStateDurationString;
    @Nullable
    private final String totalNormalStateDurationString;
    @Nullable
    private final String totalWarningStateDurationString;

    public GaugeMonitorEntry(@NotNull Entry entry) {
        super(entry);
        String currentSeverityStr = this.getString("severity");
        this.currentSeverity = currentSeverityStr == null ? null : AlarmSeverity.forName(currentSeverityStr);
        String previousSeverityStr = this.getString("previous-severity");
        this.previousSeverity = previousSeverityStr == null ? null : AlarmSeverity.forName(previousSeverityStr);
        this.summary = this.getString("summary");
        this.errorMessages = this.getStrings("error-message");
        this.initTime = this.getDate("gauge-init-time");
        this.updateTime = this.getDate("update-time");
        this.samplesThisInterval = this.getLong("samples-this-interval");
        this.currentSeverityStartTime = this.getDate("current-severity-start-time");
        this.currentSeverityDurationString = this.getString("current-severity-duration");
        this.currentSeverityDurationMillis = this.getLong("current-severity-duration-millis");
        this.lastNormalStateStartTime = this.getDate("last-normal-state-start-time");
        this.lastNormalStateEndTime = this.getDate("last-normal-state-end-time");
        this.lastNormalStateDurationString = this.getString("last-normal-state-duration");
        this.lastNormalStateDurationMillis = this.getLong("last-normal-state-duration-millis");
        this.totalNormalStateDurationString = this.getString("total-normal-state-duration");
        this.totalNormalStateDurationMillis = this.getLong("total-normal-state-duration-millis");
        this.lastWarningStateStartTime = this.getDate("last-warning-state-start-time");
        this.lastWarningStateEndTime = this.getDate("last-warning-state-end-time");
        this.lastWarningStateDurationString = this.getString("last-warning-state-duration");
        this.lastWarningStateDurationMillis = this.getLong("last-warning-state-duration-millis");
        this.totalWarningStateDurationString = this.getString("total-warning-state-duration");
        this.totalWarningStateDurationMillis = this.getLong("total-warning-state-duration-millis");
        this.lastMinorStateStartTime = this.getDate("last-minor-state-start-time");
        this.lastMinorStateEndTime = this.getDate("last-minor-state-end-time");
        this.lastMinorStateDurationString = this.getString("last-minor-state-duration");
        this.lastMinorStateDurationMillis = this.getLong("last-minor-state-duration-millis");
        this.totalMinorStateDurationString = this.getString("total-minor-state-duration");
        this.totalMinorStateDurationMillis = this.getLong("total-minor-state-duration-millis");
        this.lastMajorStateStartTime = this.getDate("last-major-state-start-time");
        this.lastMajorStateEndTime = this.getDate("last-major-state-end-time");
        this.lastMajorStateDurationString = this.getString("last-major-state-duration");
        this.lastMajorStateDurationMillis = this.getLong("last-major-state-duration-millis");
        this.totalMajorStateDurationString = this.getString("total-major-state-duration");
        this.totalMajorStateDurationMillis = this.getLong("total-major-state-duration-millis");
        this.lastCriticalStateStartTime = this.getDate("last-critical-state-start-time");
        this.lastCriticalStateEndTime = this.getDate("last-critical-state-end-time");
        this.lastCriticalStateDurationString = this.getString("last-critical-state-duration");
        this.lastCriticalStateDurationMillis = this.getLong("last-critical-state-duration-millis");
        this.totalCriticalStateDurationString = this.getString("total-critical-state-duration");
        this.totalCriticalStateDurationMillis = this.getLong("total-critical-state-duration-millis");
    }

    @Nullable
    public final String getGaugeName() {
        return this.gaugeName;
    }

    @Nullable
    public final String getResource() {
        return this.resource;
    }

    @Nullable
    public final String getResourceType() {
        return this.resourceType;
    }

    @Nullable
    public final AlarmSeverity getCurrentSeverity() {
        return this.currentSeverity;
    }

    @Nullable
    public final AlarmSeverity getPreviousSeverity() {
        return this.previousSeverity;
    }

    @Nullable
    public final String getSummary() {
        return this.summary;
    }

    @NotNull
    public final List<String> getErrorMessages() {
        return this.errorMessages;
    }

    @Nullable
    public final Date getInitTime() {
        return this.initTime;
    }

    @Nullable
    public final Date getUpdateTime() {
        return this.updateTime;
    }

    @Nullable
    public final Long getSamplesThisInterval() {
        return this.samplesThisInterval;
    }

    @Nullable
    public final Date getCurrentSeverityStartTime() {
        return this.currentSeverityStartTime;
    }

    @Nullable
    public final String getCurrentSeverityDurationString() {
        return this.currentSeverityDurationString;
    }

    @Nullable
    public final Long getCurrentSeverityDurationMillis() {
        return this.currentSeverityDurationMillis;
    }

    @Nullable
    public final Date getLastNormalStateStartTime() {
        return this.lastNormalStateStartTime;
    }

    @Nullable
    public final Date getLastNormalStateEndTime() {
        return this.lastNormalStateEndTime;
    }

    @Nullable
    public final String getLastNormalStateDurationString() {
        return this.lastNormalStateDurationString;
    }

    @Nullable
    public final Long getLastNormalStateDurationMillis() {
        return this.lastNormalStateDurationMillis;
    }

    @Nullable
    public final String getTotalNormalStateDurationString() {
        return this.totalNormalStateDurationString;
    }

    @Nullable
    public final Long getTotalNormalStateDurationMillis() {
        return this.totalNormalStateDurationMillis;
    }

    @Nullable
    public final Date getLastWarningStateStartTime() {
        return this.lastWarningStateStartTime;
    }

    @Nullable
    public final Date getLastWarningStateEndTime() {
        return this.lastWarningStateEndTime;
    }

    @Nullable
    public final String getLastWarningStateDurationString() {
        return this.lastWarningStateDurationString;
    }

    @Nullable
    public final Long getLastWarningStateDurationMillis() {
        return this.lastWarningStateDurationMillis;
    }

    @Nullable
    public final String getTotalWarningStateDurationString() {
        return this.totalWarningStateDurationString;
    }

    @Nullable
    public final Long getTotalWarningStateDurationMillis() {
        return this.totalWarningStateDurationMillis;
    }

    @Nullable
    public final Date getLastMinorStateStartTime() {
        return this.lastMinorStateStartTime;
    }

    @Nullable
    public final Date getLastMinorStateEndTime() {
        return this.lastMinorStateEndTime;
    }

    @Nullable
    public final String getLastMinorStateDurationString() {
        return this.lastMinorStateDurationString;
    }

    @Nullable
    public final Long getLastMinorStateDurationMillis() {
        return this.lastMinorStateDurationMillis;
    }

    @Nullable
    public final String getTotalMinorStateDurationString() {
        return this.totalMinorStateDurationString;
    }

    @Nullable
    public final Long getTotalMinorStateDurationMillis() {
        return this.totalMinorStateDurationMillis;
    }

    @Nullable
    public final Date getLastMajorStateStartTime() {
        return this.lastMajorStateStartTime;
    }

    @Nullable
    public final Date getLastMajorStateEndTime() {
        return this.lastMajorStateEndTime;
    }

    @Nullable
    public final String getLastMajorStateDurationString() {
        return this.lastMajorStateDurationString;
    }

    @Nullable
    public final Long getLastMajorStateDurationMillis() {
        return this.lastMajorStateDurationMillis;
    }

    @Nullable
    public final String getTotalMajorStateDurationString() {
        return this.totalMajorStateDurationString;
    }

    @Nullable
    public final Long getTotalMajorStateDurationMillis() {
        return this.totalMajorStateDurationMillis;
    }

    @Nullable
    public final Date getLastCriticalStateStartTime() {
        return this.lastCriticalStateStartTime;
    }

    @Nullable
    public final Date getLastCriticalStateEndTime() {
        return this.lastCriticalStateEndTime;
    }

    @Nullable
    public final String getLastCriticalStateDurationString() {
        return this.lastCriticalStateDurationString;
    }

    @Nullable
    public final Long getLastCriticalStateDurationMillis() {
        return this.lastCriticalStateDurationMillis;
    }

    @Nullable
    public final String getTotalCriticalStateDurationString() {
        return this.totalCriticalStateDurationString;
    }

    @Nullable
    public final Long getTotalCriticalStateDurationMillis() {
        return this.totalCriticalStateDurationMillis;
    }

    @Override
    @NotNull
    public String getMonitorDisplayName() {
        return MonitorMessages.INFO_GAUGE_MONITOR_DISPNAME.get();
    }

    @Override
    @NotNull
    public String getMonitorDescription() {
        return MonitorMessages.INFO_GAUGE_MONITOR_DESC.get();
    }

    @Override
    @NotNull
    public Map<String, MonitorAttribute> getMonitorAttributes() {
        LinkedHashMap<String, MonitorAttribute> attrs = new LinkedHashMap<String, MonitorAttribute>(StaticUtils.computeMapCapacity(43));
        if (this.gaugeName != null) {
            GaugeMonitorEntry.addMonitorAttribute(attrs, "gauge-name", MonitorMessages.INFO_GAUGE_DISPNAME_GAUGE_NAME.get(), MonitorMessages.INFO_GAUGE_DESC_GAUGE_NAME.get(), this.gaugeName);
        }
        if (this.resource != null) {
            GaugeMonitorEntry.addMonitorAttribute(attrs, "resource", MonitorMessages.INFO_GAUGE_DISPNAME_RESOURCE.get(), MonitorMessages.INFO_GAUGE_DESC_RESOURCE.get(), this.resource);
        }
        if (this.resourceType != null) {
            GaugeMonitorEntry.addMonitorAttribute(attrs, "resource-type", MonitorMessages.INFO_GAUGE_DISPNAME_RESOURCE_TYPE.get(), MonitorMessages.INFO_GAUGE_DESC_RESOURCE_TYPE.get(), this.resourceType);
        }
        if (this.currentSeverity != null) {
            GaugeMonitorEntry.addMonitorAttribute(attrs, "severity", MonitorMessages.INFO_GAUGE_DISPNAME_CURRENT_SEVERITY.get(), MonitorMessages.INFO_GAUGE_DESC_CURRENT_SEVERITY.get(), this.currentSeverity.name());
        }
        if (this.previousSeverity != null) {
            GaugeMonitorEntry.addMonitorAttribute(attrs, "previous-severity", MonitorMessages.INFO_GAUGE_DISPNAME_PREVIOUS_SEVERITY.get(), MonitorMessages.INFO_GAUGE_DESC_PREVIOUS_SEVERITY.get(), this.previousSeverity.name());
        }
        if (this.summary != null) {
            GaugeMonitorEntry.addMonitorAttribute(attrs, "summary", MonitorMessages.INFO_GAUGE_DISPNAME_SUMMARY.get(), MonitorMessages.INFO_GAUGE_DESC_SUMMARY.get(), this.summary);
        }
        if (!this.errorMessages.isEmpty()) {
            GaugeMonitorEntry.addMonitorAttribute(attrs, "error-message", MonitorMessages.INFO_GAUGE_DISPNAME_ERROR_MESSAGE.get(), MonitorMessages.INFO_GAUGE_DESC_ERROR_MESSAGE.get(), this.errorMessages);
        }
        if (this.initTime != null) {
            GaugeMonitorEntry.addMonitorAttribute(attrs, "gauge-init-time", MonitorMessages.INFO_GAUGE_DISPNAME_INIT_TIME.get(), MonitorMessages.INFO_GAUGE_DESC_INIT_TIME.get(), this.initTime);
        }
        if (this.updateTime != null) {
            GaugeMonitorEntry.addMonitorAttribute(attrs, "update-time", MonitorMessages.INFO_GAUGE_DISPNAME_UPDATE_TIME.get(), MonitorMessages.INFO_GAUGE_DESC_UPDATE_TIME.get(), this.updateTime);
        }
        if (this.samplesThisInterval != null) {
            GaugeMonitorEntry.addMonitorAttribute(attrs, "samples-this-interval", MonitorMessages.INFO_GAUGE_DISPNAME_SAMPLES_THIS_INTERVAL.get(), MonitorMessages.INFO_GAUGE_DESC_SAMPLES_THIS_INTERVAL.get(), this.samplesThisInterval);
        }
        if (this.currentSeverityStartTime != null) {
            GaugeMonitorEntry.addMonitorAttribute(attrs, "current-severity-start-time", MonitorMessages.INFO_GAUGE_DISPNAME_CURRENT_START_TIME.get(), MonitorMessages.INFO_GAUGE_DESC_CURRENT_START_TIME.get(), this.currentSeverityStartTime);
        }
        if (this.currentSeverityDurationString != null) {
            GaugeMonitorEntry.addMonitorAttribute(attrs, "current-severity-duration", MonitorMessages.INFO_GAUGE_DISPNAME_CURRENT_DURATION_STRING.get(), MonitorMessages.INFO_GAUGE_DESC_CURRENT_DURATION_STRING.get(), this.currentSeverityDurationString);
        }
        if (this.currentSeverityDurationMillis != null) {
            GaugeMonitorEntry.addMonitorAttribute(attrs, "current-severity-duration-millis", MonitorMessages.INFO_GAUGE_DISPNAME_CURRENT_DURATION_MILLIS.get(), MonitorMessages.INFO_GAUGE_DESC_CURRENT_DURATION_MILLIS.get(), this.currentSeverityDurationMillis);
        }
        if (this.lastNormalStateStartTime != null) {
            GaugeMonitorEntry.addMonitorAttribute(attrs, "last-normal-state-start-time", MonitorMessages.INFO_GAUGE_DISPNAME_LAST_NORMAL_START_TIME.get(), MonitorMessages.INFO_GAUGE_DESC_LAST_NORMAL_START_TIME.get(), this.lastNormalStateStartTime);
        }
        if (this.lastNormalStateEndTime != null) {
            GaugeMonitorEntry.addMonitorAttribute(attrs, "last-normal-state-end-time", MonitorMessages.INFO_GAUGE_DISPNAME_LAST_NORMAL_END_TIME.get(), MonitorMessages.INFO_GAUGE_DESC_LAST_NORMAL_END_TIME.get(), this.lastNormalStateEndTime);
        }
        if (this.lastNormalStateDurationString != null) {
            GaugeMonitorEntry.addMonitorAttribute(attrs, "last-normal-state-duration", MonitorMessages.INFO_GAUGE_DISPNAME_LAST_NORMAL_DURATION_STRING.get(), MonitorMessages.INFO_GAUGE_DESC_LAST_NORMAL_DURATION_STRING.get(), this.lastNormalStateDurationString);
        }
        if (this.lastNormalStateDurationMillis != null) {
            GaugeMonitorEntry.addMonitorAttribute(attrs, "last-normal-state-duration-millis", MonitorMessages.INFO_GAUGE_DISPNAME_LAST_NORMAL_DURATION_MILLIS.get(), MonitorMessages.INFO_GAUGE_DESC_LAST_NORMAL_DURATION_MILLIS.get(), this.lastNormalStateDurationMillis);
        }
        if (this.totalNormalStateDurationString != null) {
            GaugeMonitorEntry.addMonitorAttribute(attrs, "total-normal-state-duration", MonitorMessages.INFO_GAUGE_DISPNAME_TOTAL_NORMAL_DURATION_STRING.get(), MonitorMessages.INFO_GAUGE_DESC_TOTAL_NORMAL_DURATION_STRING.get(), this.totalNormalStateDurationString);
        }
        if (this.totalNormalStateDurationMillis != null) {
            GaugeMonitorEntry.addMonitorAttribute(attrs, "total-normal-state-duration-millis", MonitorMessages.INFO_GAUGE_DISPNAME_TOTAL_NORMAL_DURATION_MILLIS.get(), MonitorMessages.INFO_GAUGE_DESC_TOTAL_NORMAL_DURATION_MILLIS.get(), this.totalNormalStateDurationMillis);
        }
        if (this.lastWarningStateStartTime != null) {
            GaugeMonitorEntry.addMonitorAttribute(attrs, "last-warning-state-start-time", MonitorMessages.INFO_GAUGE_DISPNAME_LAST_WARNING_START_TIME.get(), MonitorMessages.INFO_GAUGE_DESC_LAST_WARNING_START_TIME.get(), this.lastWarningStateStartTime);
        }
        if (this.lastWarningStateEndTime != null) {
            GaugeMonitorEntry.addMonitorAttribute(attrs, "last-warning-state-end-time", MonitorMessages.INFO_GAUGE_DISPNAME_LAST_WARNING_END_TIME.get(), MonitorMessages.INFO_GAUGE_DESC_LAST_WARNING_END_TIME.get(), this.lastWarningStateEndTime);
        }
        if (this.lastWarningStateDurationString != null) {
            GaugeMonitorEntry.addMonitorAttribute(attrs, "last-warning-state-duration", MonitorMessages.INFO_GAUGE_DISPNAME_LAST_WARNING_DURATION_STRING.get(), MonitorMessages.INFO_GAUGE_DESC_LAST_WARNING_DURATION_STRING.get(), this.lastWarningStateDurationString);
        }
        if (this.lastWarningStateDurationMillis != null) {
            GaugeMonitorEntry.addMonitorAttribute(attrs, "last-warning-state-duration-millis", MonitorMessages.INFO_GAUGE_DISPNAME_LAST_WARNING_DURATION_MILLIS.get(), MonitorMessages.INFO_GAUGE_DESC_LAST_WARNING_DURATION_MILLIS.get(), this.lastWarningStateDurationMillis);
        }
        if (this.totalWarningStateDurationString != null) {
            GaugeMonitorEntry.addMonitorAttribute(attrs, "total-warning-state-duration", MonitorMessages.INFO_GAUGE_DISPNAME_TOTAL_WARNING_DURATION_STRING.get(), MonitorMessages.INFO_GAUGE_DESC_TOTAL_WARNING_DURATION_STRING.get(), this.totalWarningStateDurationString);
        }
        if (this.totalWarningStateDurationMillis != null) {
            GaugeMonitorEntry.addMonitorAttribute(attrs, "total-warning-state-duration-millis", MonitorMessages.INFO_GAUGE_DISPNAME_TOTAL_WARNING_DURATION_MILLIS.get(), MonitorMessages.INFO_GAUGE_DESC_TOTAL_WARNING_DURATION_MILLIS.get(), this.totalWarningStateDurationMillis);
        }
        if (this.lastMinorStateStartTime != null) {
            GaugeMonitorEntry.addMonitorAttribute(attrs, "last-minor-state-start-time", MonitorMessages.INFO_GAUGE_DISPNAME_LAST_MINOR_START_TIME.get(), MonitorMessages.INFO_GAUGE_DESC_LAST_MINOR_START_TIME.get(), this.lastMinorStateStartTime);
        }
        if (this.lastMinorStateEndTime != null) {
            GaugeMonitorEntry.addMonitorAttribute(attrs, "last-minor-state-end-time", MonitorMessages.INFO_GAUGE_DISPNAME_LAST_MINOR_END_TIME.get(), MonitorMessages.INFO_GAUGE_DESC_LAST_MINOR_END_TIME.get(), this.lastMinorStateEndTime);
        }
        if (this.lastMinorStateDurationString != null) {
            GaugeMonitorEntry.addMonitorAttribute(attrs, "last-minor-state-duration", MonitorMessages.INFO_GAUGE_DISPNAME_LAST_MINOR_DURATION_STRING.get(), MonitorMessages.INFO_GAUGE_DESC_LAST_MINOR_DURATION_STRING.get(), this.lastMinorStateDurationString);
        }
        if (this.lastMinorStateDurationMillis != null) {
            GaugeMonitorEntry.addMonitorAttribute(attrs, "last-minor-state-duration-millis", MonitorMessages.INFO_GAUGE_DISPNAME_LAST_MINOR_DURATION_MILLIS.get(), MonitorMessages.INFO_GAUGE_DESC_LAST_MINOR_DURATION_MILLIS.get(), this.lastMinorStateDurationMillis);
        }
        if (this.totalMinorStateDurationString != null) {
            GaugeMonitorEntry.addMonitorAttribute(attrs, "total-minor-state-duration", MonitorMessages.INFO_GAUGE_DISPNAME_TOTAL_MINOR_DURATION_STRING.get(), MonitorMessages.INFO_GAUGE_DESC_TOTAL_MINOR_DURATION_STRING.get(), this.totalMinorStateDurationString);
        }
        if (this.totalMinorStateDurationMillis != null) {
            GaugeMonitorEntry.addMonitorAttribute(attrs, "total-minor-state-duration-millis", MonitorMessages.INFO_GAUGE_DISPNAME_TOTAL_MINOR_DURATION_MILLIS.get(), MonitorMessages.INFO_GAUGE_DESC_TOTAL_MINOR_DURATION_MILLIS.get(), this.totalMinorStateDurationMillis);
        }
        if (this.lastMajorStateStartTime != null) {
            GaugeMonitorEntry.addMonitorAttribute(attrs, "last-major-state-start-time", MonitorMessages.INFO_GAUGE_DISPNAME_LAST_MAJOR_START_TIME.get(), MonitorMessages.INFO_GAUGE_DESC_LAST_MAJOR_START_TIME.get(), this.lastMajorStateStartTime);
        }
        if (this.lastMajorStateEndTime != null) {
            GaugeMonitorEntry.addMonitorAttribute(attrs, "last-major-state-end-time", MonitorMessages.INFO_GAUGE_DISPNAME_LAST_MAJOR_END_TIME.get(), MonitorMessages.INFO_GAUGE_DESC_LAST_MAJOR_END_TIME.get(), this.lastMajorStateEndTime);
        }
        if (this.lastMajorStateDurationString != null) {
            GaugeMonitorEntry.addMonitorAttribute(attrs, "last-major-state-duration", MonitorMessages.INFO_GAUGE_DISPNAME_LAST_MAJOR_DURATION_STRING.get(), MonitorMessages.INFO_GAUGE_DESC_LAST_MAJOR_DURATION_STRING.get(), this.lastMajorStateDurationString);
        }
        if (this.lastMajorStateDurationMillis != null) {
            GaugeMonitorEntry.addMonitorAttribute(attrs, "last-major-state-duration-millis", MonitorMessages.INFO_GAUGE_DISPNAME_LAST_MAJOR_DURATION_MILLIS.get(), MonitorMessages.INFO_GAUGE_DESC_LAST_MAJOR_DURATION_MILLIS.get(), this.lastMajorStateDurationMillis);
        }
        if (this.totalMajorStateDurationString != null) {
            GaugeMonitorEntry.addMonitorAttribute(attrs, "total-major-state-duration", MonitorMessages.INFO_GAUGE_DISPNAME_TOTAL_MAJOR_DURATION_STRING.get(), MonitorMessages.INFO_GAUGE_DESC_TOTAL_MAJOR_DURATION_STRING.get(), this.totalMajorStateDurationString);
        }
        if (this.totalMajorStateDurationMillis != null) {
            GaugeMonitorEntry.addMonitorAttribute(attrs, "total-major-state-duration-millis", MonitorMessages.INFO_GAUGE_DISPNAME_TOTAL_MAJOR_DURATION_MILLIS.get(), MonitorMessages.INFO_GAUGE_DESC_TOTAL_MAJOR_DURATION_MILLIS.get(), this.totalMajorStateDurationMillis);
        }
        if (this.lastCriticalStateStartTime != null) {
            GaugeMonitorEntry.addMonitorAttribute(attrs, "last-critical-state-start-time", MonitorMessages.INFO_GAUGE_DISPNAME_LAST_CRITICAL_START_TIME.get(), MonitorMessages.INFO_GAUGE_DESC_LAST_CRITICAL_START_TIME.get(), this.lastCriticalStateStartTime);
        }
        if (this.lastCriticalStateEndTime != null) {
            GaugeMonitorEntry.addMonitorAttribute(attrs, "last-critical-state-end-time", MonitorMessages.INFO_GAUGE_DISPNAME_LAST_CRITICAL_END_TIME.get(), MonitorMessages.INFO_GAUGE_DESC_LAST_CRITICAL_END_TIME.get(), this.lastCriticalStateEndTime);
        }
        if (this.lastCriticalStateDurationString != null) {
            GaugeMonitorEntry.addMonitorAttribute(attrs, "last-critical-state-duration", MonitorMessages.INFO_GAUGE_DISPNAME_LAST_CRITICAL_DURATION_STRING.get(), MonitorMessages.INFO_GAUGE_DESC_LAST_CRITICAL_DURATION_STRING.get(), this.lastCriticalStateDurationString);
        }
        if (this.lastCriticalStateDurationMillis != null) {
            GaugeMonitorEntry.addMonitorAttribute(attrs, "last-critical-state-duration-millis", MonitorMessages.INFO_GAUGE_DISPNAME_LAST_CRITICAL_DURATION_MILLIS.get(), MonitorMessages.INFO_GAUGE_DESC_LAST_CRITICAL_DURATION_MILLIS.get(), this.lastCriticalStateDurationMillis);
        }
        if (this.totalCriticalStateDurationString != null) {
            GaugeMonitorEntry.addMonitorAttribute(attrs, "total-critical-state-duration", MonitorMessages.INFO_GAUGE_DISPNAME_TOTAL_CRITICAL_DURATION_STRING.get(), MonitorMessages.INFO_GAUGE_DESC_TOTAL_CRITICAL_DURATION_STRING.get(), this.totalCriticalStateDurationString);
        }
        if (this.totalCriticalStateDurationMillis != null) {
            GaugeMonitorEntry.addMonitorAttribute(attrs, "total-critical-state-duration-millis", MonitorMessages.INFO_GAUGE_DISPNAME_TOTAL_CRITICAL_DURATION_MILLIS.get(), MonitorMessages.INFO_GAUGE_DESC_TOTAL_CRITICAL_DURATION_MILLIS.get(), this.totalCriticalStateDurationMillis);
        }
        return Collections.unmodifiableMap(attrs);
    }
}

