/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.listener.adapter;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Session;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class JmsResponse<T> {
    private final T response;
    private final Object destination;

    protected JmsResponse(T response, Object destination) {
        Assert.notNull(response, (String)"'response' must not be null");
        this.response = response;
        this.destination = destination;
    }

    public T getResponse() {
        return this.response;
    }

    @Nullable
    public Destination resolveDestination(DestinationResolver destinationResolver, Session session) throws JMSException {
        Object object = this.destination;
        if (object instanceof Destination) {
            Destination dest = (Destination)object;
            return dest;
        }
        object = this.destination;
        if (object instanceof DestinationNameHolder) {
            DestinationNameHolder nameHolder = (DestinationNameHolder)object;
            return destinationResolver.resolveDestinationName(session, nameHolder.destinationName, nameHolder.pubSubDomain);
        }
        return null;
    }

    public String toString() {
        return "JmsResponse [response=" + String.valueOf(this.response) + ", destination=" + String.valueOf(this.destination) + "]";
    }

    public static <T> JmsResponse<T> forQueue(T result, String queueName) {
        Assert.notNull((Object)queueName, (String)"Queue name must not be null");
        return new JmsResponse<T>(result, new DestinationNameHolder(queueName, false));
    }

    public static <T> JmsResponse<T> forTopic(T result, String topicName) {
        Assert.notNull((Object)topicName, (String)"Topic name must not be null");
        return new JmsResponse<T>(result, new DestinationNameHolder(topicName, true));
    }

    public static <T> JmsResponse<T> forDestination(T result, Destination destination) {
        Assert.notNull((Object)destination, (String)"Destination must not be null");
        return new JmsResponse<T>(result, destination);
    }

    private static class DestinationNameHolder {
        private final String destinationName;
        private final boolean pubSubDomain;

        public DestinationNameHolder(String destinationName, boolean pubSubDomain) {
            this.destinationName = destinationName;
            this.pubSubDomain = pubSubDomain;
        }

        public String toString() {
            return this.destinationName + "{pubSubDomain=" + this.pubSubDomain + "}";
        }
    }
}

