/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.websocket.jsonb;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.johnzon.websocket.jsonb.JsonbLocator;

public class JsonbLocatorDelegate
implements ServletContextListener {
    private static final Map<ClassLoader, Jsonb> BY_LOADER = new ConcurrentHashMap<ClassLoader, Jsonb>();
    private static final String ATTRIBUTE = JsonbLocator.class.getName() + ".jsonb";

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        Jsonb instance = Optional.ofNullable(servletContext.getAttribute(ATTRIBUTE)).map(Jsonb.class::cast).orElseGet(() -> {
            Jsonb jsonb = JsonbLocatorDelegate.newInstance();
            servletContext.setAttribute(ATTRIBUTE, (Object)jsonb);
            return jsonb;
        });
        BY_LOADER.put(servletContext.getClassLoader(), instance);
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        Jsonb instance = BY_LOADER.remove(servletContextEvent.getServletContext().getClassLoader());
        if (instance != null) {
            try {
                instance.close();
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Jsonb locate() {
        Jsonb jsonb;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = JsonbLocatorDelegate.class.getClassLoader();
        }
        if ((jsonb = BY_LOADER.get(loader)) == null) {
            Map<ClassLoader, Jsonb> map = BY_LOADER;
            synchronized (map) {
                jsonb = BY_LOADER.get(loader);
                if (jsonb != null) {
                    return jsonb;
                }
                jsonb = JsonbLocatorDelegate.newInstance();
                BY_LOADER.put(loader, jsonb);
                return jsonb;
            }
        }
        return jsonb;
    }

    private static Jsonb newInstance() {
        return JsonbBuilder.create();
    }
}

