/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.marshall.SimpleJson;
import org.apache.juneau.utils.MethodInvoker;
import org.apache.juneau.utils.StackTraceDatabase;
import org.apache.juneau.utils.StackTraceInfo;
import org.apache.juneau.utils.WeightedAverage;

@Bean(bpi="method,runs,running,errors,minTime,maxTime,avgTime,totalTime,exceptions")
public class MethodExecStats
implements Comparable<MethodExecStats> {
    private String method;
    private WeightedAverage avgTime = new WeightedAverage();
    private volatile int minTime = -1;
    private volatile int maxTime;
    private AtomicInteger starts = new AtomicInteger();
    private AtomicInteger finishes = new AtomicInteger();
    private AtomicInteger errors = new AtomicInteger();
    private AtomicLong totalTime = new AtomicLong();
    private StackTraceDatabase stackTraceDb;

    public MethodExecStats(Method method, Class<?> stackTraceStopClass) {
        this.method = method.getDeclaringClass().getSimpleName() + "." + method.getName();
        this.stackTraceDb = new StackTraceDatabase(-1L, stackTraceStopClass);
    }

    public MethodExecStats(Method method) {
        this(method, MethodInvoker.class);
    }

    public void started() {
        this.starts.incrementAndGet();
    }

    public void finished(long nanoTime) {
        this.finishes.incrementAndGet();
        int milliTime = (int)(nanoTime / 1000000L);
        this.totalTime.addAndGet(nanoTime);
        this.avgTime.add(1, nanoTime);
        this.minTime = this.minTime == -1 ? milliTime : Math.min(this.minTime, milliTime);
        this.maxTime = Math.max(this.maxTime, milliTime);
    }

    public void error(Throwable e) {
        this.errors.incrementAndGet();
        this.stackTraceDb.add(e);
    }

    public String getMethod() {
        return this.method;
    }

    public int getRuns() {
        return this.starts.get();
    }

    public int getRunning() {
        return this.starts.get() - this.finishes.get();
    }

    public int getErrors() {
        return this.errors.get();
    }

    public int getMinTime() {
        return this.minTime == -1 ? 0 : this.minTime;
    }

    public int getMaxTime() {
        return this.maxTime;
    }

    public int getAvgTime() {
        return (int)this.avgTime.getValue() / 1000000;
    }

    public long getTotalTime() {
        return this.totalTime.get() / 1000000L;
    }

    public List<StackTraceInfo> getExceptions() {
        return this.stackTraceDb.getClonedStackTraceInfos();
    }

    public String toString() {
        return SimpleJson.DEFAULT.toString(this);
    }

    @Override
    public int compareTo(MethodExecStats o) {
        return Long.compare(o.getTotalTime(), this.getTotalTime());
    }
}

