/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.mock2;

import java.net.URI;
import java.security.Principal;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;
import org.apache.juneau.rest.client2.RestCallException;
import org.apache.juneau.rest.client2.RestClient;
import org.apache.juneau.rest.client2.RestRequest;

public class MockRestRequest
extends RestRequest {
    private Map<String, Object> attributeMap = new LinkedHashMap<String, Object>();
    private Map<String, RequestDispatcher> requestDispatcherMap = new LinkedHashMap<String, RequestDispatcher>();
    private String characterEncoding;
    private String protocol;
    private String scheme;
    private String serverName;
    private String remoteAddr;
    private String remoteHost;
    private String localName;
    private String localAddr;
    private String pathInfo;
    private String pathTranslated;
    private String contextPath;
    private String queryString;
    private String remoteUser;
    private String requestedSessionId;
    private String requestURI;
    private String servletPath;
    private String authType;
    private Integer serverPort;
    private Integer remotePort;
    private Integer localPort;
    private Locale locale;
    private ServletContext servletContext;
    private DispatcherType dispatcherType;
    private Cookie[] cookies;
    private Principal userPrincipal;
    private HttpSession httpSession;
    private String[] roles;

    protected MockRestRequest(RestClient client, URI uri, String method, boolean hasBody) throws RestCallException {
        super(client, uri, method, hasBody);
    }

    public MockRestRequest attribute(String name, Object value) {
        this.attributeMap.put(name, value);
        return this;
    }

    public MockRestRequest attributes(Map<String, Object> value) {
        this.attributeMap.clear();
        this.attributeMap.putAll(value);
        return this;
    }

    public Map<String, Object> getAttributeMap() {
        return this.attributeMap;
    }

    public MockRestRequest roles(String ... roles) {
        this.roles = roles;
        return this;
    }

    public String[] getRoles() {
        return this.roles;
    }

    public MockRestRequest role(String role) {
        this.roles = new String[]{role};
        return this;
    }

    public MockRestRequest characterEncoding(String value) {
        this.characterEncoding = value;
        return this;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public MockRestRequest protocol(String value) {
        this.protocol = value;
        return this;
    }

    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public MockRestRequest scheme(String value) {
        super.scheme(value);
        this.scheme = value;
        return this;
    }

    public String getScheme() {
        return this.scheme;
    }

    public MockRestRequest serverName(String value) {
        this.serverName = value;
        return this;
    }

    public String getServerName() {
        return this.serverName;
    }

    public MockRestRequest serverPort(int value) {
        this.serverPort = value;
        return this;
    }

    public Integer getServerPort() {
        return this.serverPort;
    }

    public MockRestRequest remoteAddr(String value) {
        this.remoteAddr = value;
        return this;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public MockRestRequest remoteHost(String value) {
        this.remoteHost = value;
        return this;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public MockRestRequest locale(Locale value) {
        this.locale = value;
        return this;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public MockRestRequest remotePort(int value) {
        this.remotePort = value;
        return this;
    }

    public Integer getRemotePort() {
        return this.remotePort;
    }

    public MockRestRequest localName(String value) {
        this.localName = value;
        return this;
    }

    public String getLocalName() {
        return this.localName;
    }

    public MockRestRequest localAddr(String value) {
        this.localAddr = value;
        return this;
    }

    public String getLocalAddr() {
        return this.localAddr;
    }

    public MockRestRequest localPort(int value) {
        this.localPort = value;
        return this;
    }

    public Integer getLocalPort() {
        return this.localPort;
    }

    public MockRestRequest requestDispatcher(String path, RequestDispatcher value) {
        this.requestDispatcherMap.put(path, value);
        return this;
    }

    public Map<String, RequestDispatcher> getRequestDispatcherMap() {
        return this.requestDispatcherMap;
    }

    public MockRestRequest servletContext(ServletContext value) {
        this.servletContext = value;
        return this;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public MockRestRequest dispatcherType(DispatcherType value) {
        this.dispatcherType = value;
        return this;
    }

    public DispatcherType getDispatcherType() {
        return this.dispatcherType;
    }

    public MockRestRequest authType(String value) {
        this.authType = value;
        return this;
    }

    public String getAuthType() {
        return this.authType;
    }

    public MockRestRequest cookies(Cookie[] value) {
        this.cookies = value;
        return this;
    }

    public Cookie[] getCookies() {
        return this.cookies;
    }

    public MockRestRequest pathInfo(String value) {
        this.pathInfo = value;
        return this;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public MockRestRequest pathTranslated(String value) {
        this.pathTranslated = value;
        return this;
    }

    public String getPathTranslated() {
        return this.pathTranslated;
    }

    public MockRestRequest contextPath(String value) {
        this.contextPath = value;
        return this;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public MockRestRequest queryString(String value) {
        this.queryString = value;
        return this;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public MockRestRequest remoteUser(String value) {
        this.remoteUser = value;
        return this;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public MockRestRequest userPrincipal(Principal value) {
        this.userPrincipal = value;
        return this;
    }

    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    public MockRestRequest requestedSessionId(String value) {
        this.requestedSessionId = value;
        return this;
    }

    public String getRequestedSessionId() {
        return this.requestedSessionId;
    }

    public MockRestRequest requestURI(String value) {
        this.requestURI = value;
        return this;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public MockRestRequest servletPath(String value) {
        this.servletPath = value;
        return this;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public MockRestRequest httpSession(HttpSession value) {
        this.httpSession = value;
        return this;
    }

    public HttpSession getHttpSession() {
        return this.httpSession;
    }
}

