/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.util.XMLEventAllocator;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.DefaultFilteringOMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.parser.ParserSessionArgs;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.xml.XmlBeanMeta;
import org.apache.juneau.xml.XmlBeanPropertyMeta;
import org.apache.juneau.xml.XmlClassMeta;
import org.apache.juneau.xml.XmlCommon;
import org.apache.juneau.xml.XmlMetaProvider;
import org.apache.juneau.xml.XmlParserBuilder;
import org.apache.juneau.xml.XmlParserSession;

@ConfigurableContext
public class XmlParser
extends ReaderParser
implements XmlMetaProvider,
XmlCommon {
    static final String PREFIX = "XmlParser";
    public static final String XML_eventAllocator = "XmlParser.eventAllocator.c";
    public static final String XML_preserveRootElement = "XmlParser.preserveRootElement.b";
    public static final String XML_reporter = "XmlParser.reporter.c";
    public static final String XML_resolver = "XmlParser.resolver.c";
    public static final String XML_validating = "XmlParser.validating.b";
    public static final XmlParser DEFAULT = new XmlParser(PropertyStore.DEFAULT);
    private final boolean validating;
    private final boolean preserveRootElement;
    private final XMLReporter reporter;
    private final XMLResolver resolver;
    private final XMLEventAllocator eventAllocator;
    private final Map<ClassMeta<?>, XmlClassMeta> xmlClassMetas = new ConcurrentHashMap();
    private final Map<BeanMeta<?>, XmlBeanMeta> xmlBeanMetas = new ConcurrentHashMap();
    private final Map<BeanPropertyMeta, XmlBeanPropertyMeta> xmlBeanPropertyMetas = new ConcurrentHashMap<BeanPropertyMeta, XmlBeanPropertyMeta>();

    public XmlParser(PropertyStore ps) {
        this(ps, "text/xml", "application/xml");
    }

    public XmlParser(PropertyStore ps, String ... consumes) {
        super(ps, consumes);
        this.validating = this.getBooleanProperty(XML_validating, false);
        this.preserveRootElement = this.getBooleanProperty(XML_preserveRootElement, false);
        this.reporter = this.getInstanceProperty(XML_reporter, XMLReporter.class, null);
        this.resolver = this.getInstanceProperty(XML_resolver, XMLResolver.class, null);
        this.eventAllocator = this.getInstanceProperty(XML_eventAllocator, XMLEventAllocator.class, null);
    }

    @Override
    public XmlParserBuilder builder() {
        return new XmlParserBuilder(this.getPropertyStore());
    }

    public static XmlParserBuilder create() {
        return new XmlParserBuilder();
    }

    @Override
    public XmlParserSession createSession() {
        return this.createSession(this.createDefaultSessionArgs());
    }

    @Override
    public XmlParserSession createSession(ParserSessionArgs args) {
        return new XmlParserSession(this, args);
    }

    @Override
    public XmlClassMeta getXmlClassMeta(ClassMeta<?> cm) {
        XmlClassMeta m = this.xmlClassMetas.get(cm);
        if (m == null) {
            m = new XmlClassMeta(cm, this);
            this.xmlClassMetas.put(cm, m);
        }
        return m;
    }

    @Override
    public XmlBeanMeta getXmlBeanMeta(BeanMeta<?> bm) {
        XmlBeanMeta m = this.xmlBeanMetas.get(bm);
        if (m == null) {
            m = new XmlBeanMeta(bm, this);
            this.xmlBeanMetas.put(bm, m);
        }
        return m;
    }

    @Override
    public XmlBeanPropertyMeta getXmlBeanPropertyMeta(BeanPropertyMeta bpm) {
        XmlBeanPropertyMeta m = this.xmlBeanPropertyMetas.get(bpm);
        if (m == null) {
            BeanPropertyMeta dbpm = bpm.getDelegateFor();
            m = new XmlBeanPropertyMeta(dbpm, this);
            this.xmlBeanPropertyMetas.put(bpm, m);
        }
        return m;
    }

    protected final XMLEventAllocator getEventAllocator() {
        return this.eventAllocator;
    }

    protected final boolean isPreserveRootElement() {
        return this.preserveRootElement;
    }

    protected final XMLReporter getReporter() {
        return this.reporter;
    }

    protected final XMLResolver getResolver() {
        return this.resolver;
    }

    protected final boolean isValidating() {
        return this.validating;
    }

    @Override
    public OMap toMap() {
        return super.toMap().a(PREFIX, new DefaultFilteringOMap().a("validating", this.validating).a("preserveRootElement", this.preserveRootElement).a("reporter", this.reporter).a("resolver", this.resolver).a("eventAllocator", this.eventAllocator));
    }
}

