/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client.remote;

import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.bean.RequestBeanMeta;
import org.apache.juneau.internal.HttpUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.reflect.ParamInfo;
import org.apache.juneau.rest.client.remote.RemoteMetadataException;
import org.apache.juneau.rest.client.remote.RemoteMethod;
import org.apache.juneau.rest.client.remote.RemoteMethodArg;
import org.apache.juneau.rest.client.remote.RemoteMethodBeanArg;
import org.apache.juneau.rest.client.remote.RemoteMethodReturn;

public class RemoteMethodMeta {
    private final String httpMethod;
    private final String fullPath;
    private final RemoteMethodArg[] pathArgs;
    private final RemoteMethodArg[] queryArgs;
    private final RemoteMethodArg[] headerArgs;
    private final RemoteMethodArg[] formDataArgs;
    private final RemoteMethodBeanArg[] requestArgs;
    private final RemoteMethodArg bodyArg;
    private final RemoteMethodReturn methodReturn;
    private final Class<?>[] exceptions;

    public RemoteMethodMeta(String parentPath, Method m, String defaultMethod) {
        Builder b = new Builder(parentPath, m, defaultMethod);
        this.httpMethod = b.httpMethod;
        this.fullPath = b.fullPath;
        this.pathArgs = b.pathArgs.toArray(new RemoteMethodArg[b.pathArgs.size()]);
        this.queryArgs = b.queryArgs.toArray(new RemoteMethodArg[b.queryArgs.size()]);
        this.formDataArgs = b.formDataArgs.toArray(new RemoteMethodArg[b.formDataArgs.size()]);
        this.headerArgs = b.headerArgs.toArray(new RemoteMethodArg[b.headerArgs.size()]);
        this.requestArgs = b.requestArgs.toArray(new RemoteMethodBeanArg[b.requestArgs.size()]);
        this.bodyArg = b.bodyArg;
        this.methodReturn = b.methodReturn;
        this.exceptions = m.getExceptionTypes();
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public RemoteMethodArg[] getPathArgs() {
        return this.pathArgs;
    }

    public RemoteMethodArg[] getQueryArgs() {
        return this.queryArgs;
    }

    public RemoteMethodArg[] getFormDataArgs() {
        return this.formDataArgs;
    }

    public RemoteMethodArg[] getHeaderArgs() {
        return this.headerArgs;
    }

    public RemoteMethodBeanArg[] getRequestArgs() {
        return this.requestArgs;
    }

    public RemoteMethodArg getBodyArg() {
        return this.bodyArg;
    }

    public RemoteMethodReturn getReturns() {
        return this.methodReturn;
    }

    public Class<?>[] getExceptions() {
        return this.exceptions;
    }

    private static final class Builder {
        String httpMethod;
        String fullPath;
        String path;
        List<RemoteMethodArg> pathArgs = new LinkedList<RemoteMethodArg>();
        List<RemoteMethodArg> queryArgs = new LinkedList<RemoteMethodArg>();
        List<RemoteMethodArg> headerArgs = new LinkedList<RemoteMethodArg>();
        List<RemoteMethodArg> formDataArgs = new LinkedList<RemoteMethodArg>();
        List<RemoteMethodBeanArg> requestArgs = new LinkedList<RemoteMethodBeanArg>();
        RemoteMethodArg bodyArg;
        RemoteMethodReturn methodReturn;

        Builder(String parentPath, Method m, String defaultMethod) {
            org.apache.juneau.http.remote.RemoteMethod rm;
            MethodInfo mi = MethodInfo.of((Method)m);
            RemoteMethod orm = (RemoteMethod)mi.getLastAnnotation(RemoteMethod.class);
            if (orm == null) {
                orm = (RemoteMethod)mi.getResolvedReturnType().getLastAnnotation(RemoteMethod.class);
            }
            if ((rm = (org.apache.juneau.http.remote.RemoteMethod)mi.getLastAnnotation(org.apache.juneau.http.remote.RemoteMethod.class)) == null) {
                rm = (org.apache.juneau.http.remote.RemoteMethod)mi.getResolvedReturnType().getLastAnnotation(org.apache.juneau.http.remote.RemoteMethod.class);
            }
            String string = rm == null ? (orm == null ? "" : orm.method()) : (this.httpMethod = rm.method());
            String string2 = rm == null ? (orm == null ? "" : orm.path()) : (this.path = rm.path());
            if (this.path.isEmpty()) {
                this.path = HttpUtils.detectHttpPath((Method)m, (boolean)true);
            }
            if (this.httpMethod.isEmpty()) {
                this.httpMethod = HttpUtils.detectHttpMethod((Method)m, (boolean)true, (String)defaultMethod);
            }
            this.path = StringUtils.trimSlashes((String)this.path);
            if (!StringUtils.isOneOf((String)this.httpMethod, (String[])new String[]{"DELETE", "GET", "POST", "PUT", "OPTIONS", "HEAD", "CONNECT", "TRACE", "PATCH"})) {
                throw new RemoteMetadataException(m, "Invalid value specified for @RemoteMethod(httpMethod) annotation.  Valid values are [DELTE,GET,POST,PUT,OPTIONS,HEAD,CONNECT,TRACE,PATCH].", new Object[0]);
            }
            this.methodReturn = new RemoteMethodReturn(mi);
            this.fullPath = this.path.indexOf("://") != -1 ? this.path : (parentPath.isEmpty() ? StringUtils.urlEncodePath((Object)this.path) : StringUtils.trimSlashes((String)parentPath) + '/' + StringUtils.urlEncodePath((Object)this.path));
            for (ParamInfo mpi : mi.getParams()) {
                RequestBeanMeta rmba;
                RemoteMethodArg rma = RemoteMethodArg.create(mpi);
                if (rma != null) {
                    HttpPartType pt = rma.getPartType();
                    if (pt == HttpPartType.HEADER) {
                        this.headerArgs.add(rma);
                    } else if (pt == HttpPartType.QUERY) {
                        this.queryArgs.add(rma);
                    } else if (pt == HttpPartType.FORMDATA) {
                        this.formDataArgs.add(rma);
                    } else if (pt == HttpPartType.PATH) {
                        this.pathArgs.add(rma);
                    } else {
                        this.bodyArg = rma;
                    }
                }
                if ((rmba = RequestBeanMeta.create((ParamInfo)mpi, (PropertyStore)PropertyStore.DEFAULT)) == null) continue;
                this.requestArgs.add(new RemoteMethodBeanArg(mpi.getIndex(), rmba));
            }
        }
    }
}

