/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.springboot;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.Servlet;
import org.apache.juneau.rest.RestResourceResolver;
import org.apache.juneau.rest.RestServlet;
import org.apache.juneau.rest.springboot.SpringRestResourceResolver;
import org.apache.juneau.rest.springboot.annotation.JuneauRestRoot;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class JuneauRestPostProcessor
implements BeanDefinitionRegistryPostProcessor {
    private final Class<?> appClass;
    private final RestResourceResolver restResourceResolver;
    private BeanDefinitionRegistry registry;

    public JuneauRestPostProcessor(ConfigurableApplicationContext ctx, Class<?> appClass) {
        this.appClass = appClass;
        this.restResourceResolver = new SpringRestResourceResolver((ApplicationContext)ctx);
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) {
        this.registry = registry;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        try {
            JuneauRestRoot a;
            LinkedHashMap<String, RestServlet> m = new LinkedHashMap<String, RestServlet>();
            if (this.appClass != null && (a = this.appClass.getAnnotation(JuneauRestRoot.class)) != null) {
                Class<? extends RestServlet>[] classArray = a.servlets();
                int n = classArray.length;
                for (int i = 0; i < n; ++i) {
                    Class<? extends RestServlet> c = classArray[i];
                    m.put(c.getName(), c.newInstance());
                }
            }
            for (Map.Entry e : beanFactory.getBeansWithAnnotation(JuneauRestRoot.class).entrySet()) {
                if (!(e.getValue() instanceof RestServlet)) continue;
                m.put((String)e.getKey(), (RestServlet)e.getValue());
            }
            for (String beanName : beanFactory.getBeanNamesForType(RestServlet.class)) {
                AnnotatedTypeMetadata metadata;
                BeanDefinition bd = beanFactory.getBeanDefinition(beanName);
                if (!(bd.getSource() instanceof AnnotatedTypeMetadata) || !(metadata = (AnnotatedTypeMetadata)bd.getSource()).isAnnotated(JuneauRestRoot.class.getName())) continue;
                m.put(beanName, (RestServlet)beanFactory.getBean(beanName));
            }
            for (RestServlet rs : m.values()) {
                rs.setRestResourceResolver(this.restResourceResolver);
                ServletRegistrationBean reg = new ServletRegistrationBean((Servlet)rs, new String[]{'/' + rs.getPath()});
                this.registry.registerBeanDefinition(reg.getServletName(), (BeanDefinition)new RootBeanDefinition(ServletRegistrationBean.class, () -> reg));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

