/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.part;

import java.util.Optional;
import java.util.function.Supplier;
import org.apache.juneau.assertions.FluentIntegerAssertion;
import org.apache.juneau.http.part.BasicPart;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.StringUtils;

public class BasicIntegerPart
extends BasicPart {
    private final Integer value;
    private final Supplier<Integer> supplier;

    public static BasicIntegerPart of(String name, Integer value) {
        if (StringUtils.isEmpty(name) || value == null) {
            return null;
        }
        return new BasicIntegerPart(name, value);
    }

    public static BasicIntegerPart of(String name, Supplier<Integer> value) {
        if (StringUtils.isEmpty(name) || value == null) {
            return null;
        }
        return new BasicIntegerPart(name, value);
    }

    public BasicIntegerPart(String name, Integer value) {
        super(name, value);
        this.value = value;
        this.supplier = null;
    }

    public BasicIntegerPart(String name, Supplier<Integer> value) {
        super(name, value);
        this.value = null;
        this.supplier = value;
    }

    public BasicIntegerPart(String name, String value) {
        super(name, value);
        this.value = StringUtils.isEmpty(value) ? null : Integer.valueOf(value);
        this.supplier = null;
    }

    @Override
    public String getValue() {
        return StringUtils.stringify(this.value());
    }

    public Optional<Integer> asInteger() {
        return CollectionUtils.optional(this.toInteger());
    }

    public Integer toInteger() {
        return this.value();
    }

    public FluentIntegerAssertion<BasicIntegerPart> assertInteger() {
        return new FluentIntegerAssertion<BasicIntegerPart>(this.value(), this);
    }

    public Integer orElse(Integer other) {
        Integer x = this.value();
        return x != null ? x : other;
    }

    private Integer value() {
        if (this.supplier != null) {
            return this.supplier.get();
        }
        return this.value;
    }
}

