/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.part;

import java.net.URI;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.juneau.http.part.BasicPart;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.StringUtils;

public class BasicUriPart
extends BasicPart {
    private final URI value;
    private final Supplier<URI> supplier;

    public static BasicUriPart of(String name, URI value) {
        if (StringUtils.isEmpty(name) || value == null) {
            return null;
        }
        return new BasicUriPart(name, value);
    }

    public static BasicUriPart of(String name, Supplier<URI> value) {
        if (StringUtils.isEmpty(name) || value == null) {
            return null;
        }
        return new BasicUriPart(name, value);
    }

    public BasicUriPart(String name, URI value) {
        super(name, value);
        this.value = value;
        this.supplier = null;
    }

    public BasicUriPart(String name, Supplier<URI> value) {
        super(name, value);
        this.value = null;
        this.supplier = value;
    }

    public BasicUriPart(String name, String value) {
        super(name, value);
        this.value = StringUtils.isEmpty(value) ? null : URI.create(value);
        this.supplier = null;
    }

    public Optional<URI> asUri() {
        return CollectionUtils.optional(this.value());
    }

    public URI toUri() {
        return this.value();
    }

    public URI orElse(URI other) {
        URI x = this.value();
        return x != null ? x : other;
    }

    private URI value() {
        if (this.supplier != null) {
            return this.supplier.get();
        }
        return this.value;
    }
}

