/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.assertions;

import java.io.PrintStream;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.juneau.BasicAssertionError;
import org.apache.juneau.assertions.Assertion;
import org.apache.juneau.assertions.Assertions;
import org.apache.juneau.assertions.FluentArrayAssertion;
import org.apache.juneau.assertions.FluentBeanAssertion;
import org.apache.juneau.assertions.FluentBeanListAssertion;
import org.apache.juneau.assertions.FluentBooleanAssertion;
import org.apache.juneau.assertions.FluentByteArrayAssertion;
import org.apache.juneau.assertions.FluentCollectionAssertion;
import org.apache.juneau.assertions.FluentComparableAssertion;
import org.apache.juneau.assertions.FluentDateAssertion;
import org.apache.juneau.assertions.FluentIntegerAssertion;
import org.apache.juneau.assertions.FluentListAssertion;
import org.apache.juneau.assertions.FluentLongAssertion;
import org.apache.juneau.assertions.FluentMapAssertion;
import org.apache.juneau.assertions.FluentObjectAssertion;
import org.apache.juneau.assertions.FluentPrimitiveArrayAssertion;
import org.apache.juneau.assertions.FluentStringListAssertion;
import org.apache.juneau.assertions.FluentZonedDateTimeAssertion;
import org.apache.juneau.cp.Messages;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.reflect.ClassInfo;

@FluentSetters(returns="FluentAnyAssertion<T,R>")
public class FluentAnyAssertion<T, R>
extends FluentObjectAssertion<T, R> {
    private static final Messages MESSAGES = Messages.of(FluentAnyAssertion.class, "Messages");
    private static final String MSG_objectWasNotType = MESSAGES.getString("objectWasNotType");

    public FluentAnyAssertion(T value, R returns) {
        this(null, value, returns);
    }

    public FluentAnyAssertion(Assertion creator, T value, R returns) {
        super(creator, value, returns);
    }

    public <E> FluentArrayAssertion<E, R> asArray(Class<E> elementType) throws AssertionError {
        Assertions.assertArgNotNull("elementType", elementType);
        return new FluentArrayAssertion((Assertion)this, this.cast(FluentAnyAssertion.arrayClass(elementType)), this.returns());
    }

    public FluentPrimitiveArrayAssertion<Integer, int[], R> asIntArray() throws AssertionError {
        return new FluentPrimitiveArrayAssertion(this, this.cast(int[].class), this.returns());
    }

    public FluentPrimitiveArrayAssertion<Long, long[], R> asLongArray() throws AssertionError {
        return new FluentPrimitiveArrayAssertion(this, this.cast(long[].class), this.returns());
    }

    public FluentPrimitiveArrayAssertion<Short, short[], R> asShortArray() throws AssertionError {
        return new FluentPrimitiveArrayAssertion(this, this.cast(short[].class), this.returns());
    }

    public FluentPrimitiveArrayAssertion<Float, float[], R> asFloatArray() throws AssertionError {
        return new FluentPrimitiveArrayAssertion(this, this.cast(float[].class), this.returns());
    }

    public FluentPrimitiveArrayAssertion<Double, double[], R> asDoubleArray() throws AssertionError {
        return new FluentPrimitiveArrayAssertion(this, this.cast(double[].class), this.returns());
    }

    public FluentPrimitiveArrayAssertion<Character, char[], R> asCharArray() throws AssertionError {
        return new FluentPrimitiveArrayAssertion(this, this.cast(char[].class), this.returns());
    }

    public FluentPrimitiveArrayAssertion<Byte, byte[], R> asByteArray() throws AssertionError {
        return new FluentPrimitiveArrayAssertion(this, this.cast(byte[].class), this.returns());
    }

    public FluentPrimitiveArrayAssertion<Boolean, boolean[], R> asBooleanArray() throws AssertionError {
        return new FluentPrimitiveArrayAssertion(this, this.cast(boolean[].class), this.returns());
    }

    public FluentBooleanAssertion<R> asBoolean() {
        return new FluentBooleanAssertion((Assertion)this, this.cast(Boolean.class), this.returns());
    }

    public FluentByteArrayAssertion<R> asBytes() {
        return new FluentByteArrayAssertion((Assertion)this, this.cast(byte[].class), this.returns());
    }

    public FluentCollectionAssertion<Object, R> asCollection() {
        return this.asCollection(Object.class);
    }

    public <E> FluentCollectionAssertion<E, R> asCollection(Class<E> elementType) {
        Assertions.assertArgNotNull("elementType", elementType);
        return new FluentCollectionAssertion((Assertion)this, this.cast(Collection.class), this.returns());
    }

    public FluentStringListAssertion<R> asStringList() {
        return new FluentStringListAssertion((Assertion)this, this.cast(List.class), this.returns());
    }

    public <T2 extends Comparable<T2>> FluentComparableAssertion<T2, R> asComparable() {
        return new FluentComparableAssertion(this, this.cast(Comparable.class), this.returns());
    }

    public FluentDateAssertion<R> asDate() {
        return new FluentDateAssertion((Assertion)this, this.cast(Date.class), this.returns());
    }

    public FluentIntegerAssertion<R> asInteger() {
        return new FluentIntegerAssertion((Assertion)this, this.cast(Integer.class), this.returns());
    }

    public FluentLongAssertion<R> asLong() {
        return new FluentLongAssertion((Assertion)this, this.cast(Long.class), this.returns());
    }

    public FluentListAssertion<Object, R> asList() {
        return this.asList(Object.class);
    }

    public <E> FluentListAssertion<E, R> asList(Class<E> elementType) {
        Assertions.assertArgNotNull("elementType", elementType);
        return new FluentListAssertion((Assertion)this, this.cast(List.class), this.returns());
    }

    public FluentMapAssertion<String, Object, R> asMap() {
        return this.asMap(String.class, Object.class);
    }

    public <K, V> FluentMapAssertion<K, V, R> asMap(Class<K> keyType, Class<V> valueType) {
        Assertions.assertArgNotNull("keyType", keyType);
        Assertions.assertArgNotNull("valueType", valueType);
        return new FluentMapAssertion((Assertion)this, this.cast(Map.class), this.returns());
    }

    public <T2> FluentBeanAssertion<T2, R> asBean(Class<T2> beanType) {
        Assertions.assertArgNotNull("beanType", beanType);
        return new FluentBeanAssertion(this, this.cast(beanType), this.returns());
    }

    public FluentBeanAssertion<T, R> asBean() {
        return new FluentBeanAssertion(this, this.orElse(null), this.returns());
    }

    public <T2> FluentBeanListAssertion<T2, R> asBeanList(Class<T2> beanType) {
        Assertions.assertArgNotNull("beanType", beanType);
        return new FluentBeanListAssertion((Assertion)this, this.cast(List.class), this.returns());
    }

    public FluentZonedDateTimeAssertion<R> asZonedDateTime() {
        return new FluentZonedDateTimeAssertion((Assertion)this, this.cast(ZonedDateTime.class), this.returns());
    }

    @Override
    public FluentAnyAssertion<T, R> setMsg(String msg, Object ... args) {
        super.setMsg(msg, args);
        return this;
    }

    @Override
    public FluentAnyAssertion<T, R> setOut(PrintStream value) {
        super.setOut(value);
        return this;
    }

    @Override
    public FluentAnyAssertion<T, R> setSilent() {
        super.setSilent();
        return this;
    }

    @Override
    public FluentAnyAssertion<T, R> setStdOut() {
        super.setStdOut();
        return this;
    }

    @Override
    public FluentAnyAssertion<T, R> setThrowable(Class<? extends RuntimeException> value) {
        super.setThrowable((Class)value);
        return this;
    }

    private <T2> T2 cast(Class<T2> c) throws AssertionError {
        Object o = this.orElse(null);
        if (o == null || c.isInstance(o)) {
            return c.cast(o);
        }
        throw new BasicAssertionError(MSG_objectWasNotType, ClassInfo.of(c).getFullName(), o.getClass());
    }
}

