/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.resource;

import java.io.IOException;
import java.util.List;
import java.util.function.Supplier;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.juneau.http.entity.BasicHttpEntity;
import org.apache.juneau.http.entity.HttpEntityBuilder;
import org.apache.juneau.http.header.ContentEncoding;
import org.apache.juneau.http.header.ContentType;
import org.apache.juneau.http.header.HeaderList;
import org.apache.juneau.http.resource.BasicResource;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.ThrowableUtils;

@FluentSetters(returns="HttpResourceBuilder<T>")
public class HttpResourceBuilder<T extends BasicResource> {
    HeaderList headers = HeaderList.EMPTY;
    HeaderList.Builder headersBuilder;
    BasicHttpEntity entity;
    HttpEntityBuilder<?> entityBuilder;
    protected final Class<? extends BasicResource> implClass;
    protected final Class<? extends BasicHttpEntity> entityImplClass;

    public HttpResourceBuilder(Class<T> implClass, Class<? extends BasicHttpEntity> entityImplClass) {
        this.implClass = implClass;
        this.entityImplClass = entityImplClass;
    }

    public HttpResourceBuilder(T impl) {
        this.implClass = impl.getClass();
        this.headers = ((BasicResource)impl).headers;
        this.entity = ((BasicResource)impl).entity;
        this.entityImplClass = this.entity.getClass();
    }

    public T build() {
        try {
            return (T)this.implClass.getConstructor(HttpResourceBuilder.class).newInstance(this);
        }
        catch (Exception e) {
            throw ThrowableUtils.runtimeException(e);
        }
    }

    HeaderList headers() {
        if (this.headersBuilder != null) {
            return (HeaderList)this.headersBuilder.build();
        }
        if (this.headers == null) {
            return HeaderList.EMPTY;
        }
        return this.headers;
    }

    BasicHttpEntity entity() {
        if (this.entityBuilder != null) {
            return this.entityBuilder.build();
        }
        if (this.entity == null) {
            return BasicHttpEntity.EMPTY;
        }
        return this.entity;
    }

    public HttpResourceBuilder<?> copyFrom(HttpResponse response) throws IOException {
        this.headers(response.getAllHeaders());
        this.content(response.getEntity().getContent());
        return this;
    }

    public HttpEntityBuilder<?> getEntity() {
        if (this.entityBuilder == null) {
            this.entityBuilder = this.entity == null ? BasicHttpEntity.create(this.entityImplClass) : this.entity.copy();
            this.entity = null;
        }
        return this.entityBuilder;
    }

    @FluentSetter
    public HttpResourceBuilder<T> content(Object value) {
        this.getEntity().content(value);
        return this;
    }

    @FluentSetter
    public HttpResourceBuilder<T> content(Supplier<?> value) {
        this.getEntity().content(value);
        return this;
    }

    @FluentSetter
    public HttpResourceBuilder<T> contentType(String value) {
        this.getEntity().contentType(value);
        return this;
    }

    @FluentSetter
    public HttpResourceBuilder<T> contentType(ContentType value) {
        this.getEntity().contentType(value);
        return this;
    }

    @FluentSetter
    public HttpResourceBuilder<T> contentLength(long value) {
        this.getEntity().contentLength(value);
        return this;
    }

    @FluentSetter
    public HttpResourceBuilder<T> contentEncoding(String value) {
        this.getEntity().contentEncoding(value);
        return this;
    }

    @FluentSetter
    public HttpResourceBuilder<T> contentEncoding(ContentEncoding value) {
        this.getEntity().contentEncoding(value);
        return this;
    }

    @FluentSetter
    public HttpResourceBuilder<T> chunked() {
        this.getEntity().chunked();
        return this;
    }

    @FluentSetter
    public HttpResourceBuilder<T> chunked(boolean value) {
        this.getEntity().chunked(value);
        return this;
    }

    @FluentSetter
    public HttpResourceBuilder<T> cached() throws IOException {
        this.getEntity().cached();
        return this;
    }

    public HeaderList.Builder getHeaders() {
        if (this.headersBuilder == null) {
            this.headersBuilder = this.headers == null ? HeaderList.create() : this.headers.copy();
            this.headers = null;
        }
        return this.headersBuilder;
    }

    @FluentSetter
    public HttpResourceBuilder<T> headers(HeaderList value) {
        this.headers = value;
        this.headersBuilder = null;
        return this;
    }

    public HttpResourceBuilder<T> header(Header value) {
        if (value != null) {
            this.getHeaders().append(value);
        }
        return this;
    }

    public HttpResourceBuilder<T> header(String name, String value) {
        if (name != null && value != null) {
            this.getHeaders().append(name, value);
        }
        return this;
    }

    public HttpResourceBuilder<T> headers(Header ... values) {
        for (Header h : values) {
            if (h == null) continue;
            String n = h.getName();
            String v = h.getValue();
            if (!StringUtils.isNotEmpty(n)) continue;
            if (n.equalsIgnoreCase("content-type")) {
                this.contentType(v);
                continue;
            }
            if (n.equalsIgnoreCase("content-encoding")) {
                this.contentEncoding(v);
                continue;
            }
            if (n.equalsIgnoreCase("content-length")) {
                this.contentLength(Long.parseLong(v));
                continue;
            }
            this.getHeaders().append(h);
        }
        return this;
    }

    public HttpResourceBuilder<T> headers(List<Header> values) {
        this.getHeaders().append(values);
        return this;
    }
}

