/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.util.function.Consumer;
import java.util.function.Predicate;

public final class ConsumerUtils {
    public static <T> boolean test(Predicate<T> predicate, T value) {
        return predicate == null || predicate.test(value);
    }

    public static <T> boolean test(Class<T> type, Predicate<T> predicate, Object value) {
        return type.isInstance(value) && (predicate == null || predicate.test(type.cast(value)));
    }

    public static <T> void consume(Predicate<T> predicate, Consumer<T> consumer, T value) {
        if (ConsumerUtils.test(predicate, value)) {
            consumer.accept(value);
        }
    }

    public static <T> void consume(Class<T> type, Predicate<T> predicate, Consumer<T> consumer, Object value) {
        if (ConsumerUtils.test(type, predicate, value)) {
            consumer.accept(type.cast(value));
        }
    }
}

