/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class CachingHttpServletResponse
extends HttpServletResponseWrapper {
    final ByteArrayOutputStream baos = new ByteArrayOutputStream();
    final ServletOutputStream os;

    public static CachingHttpServletResponse wrap(HttpServletResponse res) throws IOException {
        if (res instanceof CachingHttpServletResponse) {
            return (CachingHttpServletResponse)res;
        }
        return new CachingHttpServletResponse(res);
    }

    protected CachingHttpServletResponse(HttpServletResponse res) throws IOException {
        super(res);
        this.os = res.getOutputStream();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return new ServletOutputStream(){

            public boolean isReady() {
                return CachingHttpServletResponse.this.os.isReady();
            }

            public void setWriteListener(WriteListener writeListener) {
                CachingHttpServletResponse.this.os.setWriteListener(writeListener);
            }

            public void write(int b) throws IOException {
                CachingHttpServletResponse.this.baos.write(b);
                CachingHttpServletResponse.this.os.write(b);
            }

            public void flush() throws IOException {
                CachingHttpServletResponse.this.os.flush();
            }

            public void close() throws IOException {
                CachingHttpServletResponse.this.os.close();
            }
        };
    }

    public byte[] getContent() {
        return this.baos.toByteArray();
    }
}

