/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.parser;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.TimeZone;
import java.util.function.Consumer;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanRegistry;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ExecutableException;
import org.apache.juneau.MediaType;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.cp.BeanCreator;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.Setter;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ParserListener;
import org.apache.juneau.parser.ParserPipe;
import org.apache.juneau.parser.Position;
import org.apache.juneau.swap.ObjectSwap;

public class ParserSession
extends BeanSession {
    private final Parser ctx;
    private final Method javaMethod;
    private final Object outer;
    private final Stack<StringBuilder> sbStack;
    private final HttpPartSchema schema;
    private BeanPropertyMeta currentProperty;
    private ClassMeta<?> currentClass;
    private final ParserListener listener;
    private Position mark = new Position(-1);
    private ParserPipe pipe;

    public static Builder create(Parser ctx) {
        return new Builder(ctx);
    }

    protected ParserSession(Builder builder) {
        super(builder);
        this.ctx = builder.ctx;
        this.javaMethod = builder.javaMethod;
        this.outer = builder.outer;
        this.schema = builder.schema;
        this.listener = BeanCreator.of(ParserListener.class).type(this.ctx.getListener()).orElse(null);
        this.sbStack = new Stack();
    }

    protected <T> T doParse(ParserPipe pipe, ClassMeta<T> type) throws IOException, ParseException, ExecutableException {
        return this.ctx.doParse(this, pipe, type);
    }

    public boolean isReaderParser() {
        return false;
    }

    protected ParserPipe createPipe(Object input) {
        return null;
    }

    public final JsonMap getLastLocation() {
        JsonMap m = new JsonMap();
        if (this.currentClass != null) {
            m.put("currentClass", (Object)this.currentClass.toString(true));
        }
        if (this.currentProperty != null) {
            m.put("currentProperty", (Object)this.currentProperty);
        }
        return m;
    }

    protected final Method getJavaMethod() {
        return this.javaMethod;
    }

    protected final Object getOuter() {
        return this.outer;
    }

    protected final void setCurrentProperty(BeanPropertyMeta currentProperty) {
        this.currentProperty = currentProperty;
    }

    protected final void setCurrentClass(ClassMeta<?> currentClass) {
        this.currentClass = currentClass;
    }

    protected final <K> K trim(K o) {
        if (this.isTrimStrings() && o instanceof String) {
            return (K)o.toString().trim();
        }
        return o;
    }

    protected final String trim(String s) {
        if (this.isTrimStrings() && s != null) {
            return s.trim();
        }
        return s;
    }

    protected final Object cast(JsonMap m, BeanPropertyMeta pMeta, ClassMeta<?> eType) {
        String btpn = this.getBeanTypePropertyName(eType);
        Object o = m.get(btpn);
        if (o == null) {
            return m;
        }
        String typeName = o.toString();
        ClassMeta<?> cm = this.getClassMeta(typeName, pMeta, eType);
        if (cm != null) {
            BeanMap<?> bm = m.getBeanSession().newBeanMap(cm.getInnerClass());
            m.forEach((k, v) -> {
                if (!k.equals(btpn)) {
                    if (v instanceof JsonMap) {
                        v = this.cast((JsonMap)v, pMeta, eType);
                    }
                    bm.put((String)k, v);
                }
            });
            return bm.getBean();
        }
        return m;
    }

    protected final ClassMeta<?> getClassMeta(String typeName, BeanPropertyMeta pMeta, ClassMeta<?> eType) {
        BeanRegistry br = null;
        if (pMeta != null && (br = pMeta.getBeanRegistry()) != null && br.hasName(typeName)) {
            return br.getClassMeta(typeName);
        }
        if (eType != null && (br = eType.getBeanRegistry()) != null && br.hasName(typeName)) {
            return br.getClassMeta(typeName);
        }
        return this.getBeanRegistry().getClassMeta(typeName);
    }

    protected final void onBeanSetterException(BeanPropertyMeta p, Throwable t) {
        if (this.listener != null) {
            this.listener.onBeanSetterException(this, t, p);
        }
        String prefix = "";
        this.addWarning("{0}Could not call setValue() on property ''{1}'' of class ''{2}'', exception = {3}", prefix, p.getName(), p.getBeanMeta().getClassMeta(), t.getLocalizedMessage());
    }

    protected final <T> void onUnknownProperty(String propertyName, BeanMap<T> beanMap, Object value) throws ParseException {
        if (propertyName.equals(this.getBeanTypePropertyName(beanMap.getClassMeta()))) {
            return;
        }
        if (!(this.isIgnoreUnknownBeanProperties() || value == null && this.isIgnoreUnknownNullBeanProperties())) {
            throw new ParseException(this, "Unknown property ''{0}'' encountered while trying to parse into class ''{1}''", propertyName, beanMap.getClassMeta());
        }
        if (this.listener != null) {
            this.listener.onUnknownBeanProperty(this, propertyName, beanMap.getClassMeta().getInnerClass(), beanMap.getBean());
        }
    }

    public final <T> T parse(Object input, Type type, Type ... args) throws ParseException, IOException {
        try (ParserPipe pipe = this.createPipe(input);){
            Object t = this.parseInner(pipe, this.getClassMeta(type, args));
            return t;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final <T> T parse(String input, Type type, Type ... args) throws ParseException {
        try (ParserPipe pipe = this.createPipe(input);){
            Object t = this.parseInner(pipe, this.getClassMeta(type, args));
            return t;
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    public final <T> T parse(Object input, Class<T> type) throws ParseException, IOException {
        try (ParserPipe pipe = this.createPipe(input);){
            T t = this.parseInner(pipe, this.getClassMeta(type));
            return t;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final <T> T parse(String input, Class<T> type) throws ParseException {
        try (ParserPipe pipe = this.createPipe(input);){
            T t = this.parseInner(pipe, this.getClassMeta(type));
            return t;
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    public final <T> T parse(Object input, ClassMeta<T> type) throws ParseException, IOException {
        try (ParserPipe pipe = this.createPipe(input);){
            T t = this.parseInner(pipe, type);
            return t;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final <T> T parse(String input, ClassMeta<T> type) throws ParseException {
        try (ParserPipe pipe = this.createPipe(input);){
            T t = this.parseInner(pipe, type);
            return t;
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    private <T> T parseInner(ParserPipe pipe, ClassMeta<T> type) throws ParseException, IOException {
        if (type.isVoid()) {
            return null;
        }
        try {
            T t = this.doParse(pipe, type);
            return t;
        }
        catch (IOException | ParseException e) {
            throw e;
        }
        catch (StackOverflowError e) {
            throw new ParseException(this, "Depth too deep.  Stack overflow occurred.", new Object[0]);
        }
        catch (Exception e) {
            throw new ParseException(this, (Throwable)e, "Exception occurred.  exception={0}, message={1}.", e.getClass().getSimpleName(), e.getLocalizedMessage());
        }
        finally {
            this.checkForWarnings();
        }
    }

    public final <K, V> Map<K, V> parseIntoMap(Object input, Map<K, V> m, Type keyType, Type valueType) throws ParseException {
        try {
            ParserPipe pipe = this.createPipe(input);
            try {
                Map<K, V> map = this.doParseIntoMap(pipe, m, keyType, valueType);
                if (pipe != null) {
                    pipe.close();
                }
                return map;
            }
            catch (Throwable throwable) {
                try {
                    if (pipe != null) {
                        try {
                            pipe.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ParseException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ParseException(this, e);
                }
            }
        }
        finally {
            this.checkForWarnings();
        }
    }

    protected <K, V> Map<K, V> doParseIntoMap(ParserPipe pipe, Map<K, V> m, Type keyType, Type valueType) throws Exception {
        throw new UnsupportedOperationException("Parser '" + ClassUtils.className(this.getClass()) + "' does not support this method.");
    }

    public final <E> Collection<E> parseIntoCollection(Object input, Collection<E> c, Type elementType) throws ParseException {
        try {
            ParserPipe pipe = this.createPipe(input);
            try {
                Collection<E> collection = this.doParseIntoCollection(pipe, c, elementType);
                if (pipe != null) {
                    pipe.close();
                }
                return collection;
            }
            catch (Throwable throwable) {
                try {
                    if (pipe != null) {
                        try {
                            pipe.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ParseException e) {
                    throw e;
                }
                catch (StackOverflowError e) {
                    throw new ParseException(this, "Depth too deep.  Stack overflow occurred.", new Object[0]);
                }
                catch (IOException e) {
                    throw new ParseException(this, (Throwable)e, "I/O exception occurred.  exception={0}, message={1}.", e.getClass().getSimpleName(), e.getLocalizedMessage());
                }
                catch (Exception e) {
                    throw new ParseException(this, (Throwable)e, "Exception occurred.  exception={0}, message={1}.", e.getClass().getSimpleName(), e.getLocalizedMessage());
                }
            }
        }
        finally {
            this.checkForWarnings();
        }
    }

    protected <E> Collection<E> doParseIntoCollection(ParserPipe pipe, Collection<E> c, Type elementType) throws Exception {
        throw new UnsupportedOperationException("Parser '" + ClassUtils.className(this.getClass()) + "' does not support this method.");
    }

    public final Object[] parseArgs(Object input, Type[] argTypes) throws ParseException {
        try {
            ParserPipe pipe = this.createPipe(input);
            try {
                Object[] objectArray = this.doParse(pipe, this.getArgsClassMeta(argTypes));
                if (pipe != null) {
                    pipe.close();
                }
                return objectArray;
            }
            catch (Throwable throwable) {
                try {
                    if (pipe != null) {
                        try {
                            pipe.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ParseException e) {
                    throw e;
                }
                catch (StackOverflowError e) {
                    throw new ParseException(this, "Depth too deep.  Stack overflow occurred.", new Object[0]);
                }
                catch (IOException e) {
                    throw new ParseException(this, (Throwable)e, "I/O exception occurred.  exception={0}, message={1}.", e.getClass().getSimpleName(), e.getLocalizedMessage());
                }
                catch (Exception e) {
                    throw new ParseException(this, (Throwable)e, "Exception occurred.  exception={0}, message={1}.", e.getClass().getSimpleName(), e.getLocalizedMessage());
                }
            }
        }
        finally {
            this.checkForWarnings();
        }
    }

    protected final <T> T convertAttrToType(Object outer, String s, ClassMeta<T> type) throws ParseException {
        ObjectSwap<T, ?> swap;
        if (s == null) {
            return null;
        }
        if (type == null) {
            type = this.object();
        }
        ClassMeta<Object> sType = (swap = type.getSwap(this)) == null ? type : swap.getSwapClassMeta(this);
        Object o = s;
        if (sType.isChar()) {
            o = StringUtils.parseCharacter((Object)s);
        } else if (sType.isNumber()) {
            o = StringUtils.parseNumber((String)s, sType.getInnerClass());
        } else if (sType.isBoolean()) {
            o = Boolean.parseBoolean(s);
        } else if (!sType.isCharSequence() && !sType.isObject()) {
            if (sType.canCreateNewInstanceFromString(outer)) {
                o = sType.newInstanceFromString(outer, s);
            } else {
                throw new ParseException(this, "Invalid conversion from string to class ''{0}''", type);
            }
        }
        if (swap != null) {
            o = this.unswap(swap, o, type);
        }
        return (T)o;
    }

    protected static final void setParent(ClassMeta<?> cm, Object o, Object parent) throws ExecutableException {
        Setter m = cm.getParentProperty();
        if (m != null) {
            m.set(o, parent);
        }
    }

    protected static final void setName(ClassMeta<?> cm, Object o, Object name) throws ExecutableException {
        Setter m;
        if (cm != null && (m = cm.getNameProperty()) != null) {
            m.set(o, name);
        }
    }

    public <T extends ParserListener> T getListener(Class<T> c) {
        return (T)this.listener;
    }

    protected ParserPipe setPipe(ParserPipe pipe) {
        this.pipe = pipe;
        return pipe;
    }

    public Position getPosition() {
        if (this.mark.line != -1 || this.mark.column != -1 || this.mark.position != -1) {
            return this.mark;
        }
        if (this.pipe == null) {
            return Position.UNKNOWN;
        }
        return this.pipe.getPosition();
    }

    protected void mark() {
        if (this.pipe != null) {
            Position p = this.pipe.getPosition();
            this.mark.line = p.line;
            this.mark.column = p.column;
            this.mark.position = p.position;
        }
    }

    protected void unmark() {
        this.mark.line = -1;
        this.mark.column = -1;
        this.mark.position = -1;
    }

    public String getInputAsString() {
        return this.pipe == null ? null : this.pipe.getInputAsString();
    }

    protected Object unswap(ObjectSwap swap, Object o, ClassMeta<?> eType) throws ParseException {
        try {
            return swap.unswap(this, o, eType);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    protected final StringBuilder getStringBuilder() {
        if (this.sbStack.isEmpty()) {
            return new StringBuilder();
        }
        return this.sbStack.pop();
    }

    protected final void returnStringBuilder(StringBuilder sb) {
        if (sb == null) {
            return;
        }
        sb.setLength(0);
        this.sbStack.push(sb);
    }

    protected final boolean isAutoCloseStreams() {
        return this.ctx.isAutoCloseStreams();
    }

    protected final int getDebugOutputLines() {
        return this.ctx.getDebugOutputLines();
    }

    public ParserListener getListener() {
        return this.listener;
    }

    protected final boolean isStrict() {
        return this.ctx.isStrict();
    }

    protected final boolean isTrimStrings() {
        return this.ctx.isTrimStrings();
    }

    protected final boolean isUnbuffered() {
        return this.ctx.isUnbuffered();
    }

    public final HttpPartSchema getSchema() {
        return this.schema;
    }

    protected final Class<? extends ParserListener> getListenerClass() {
        return this.ctx.getListener();
    }

    @Override
    protected JsonMap properties() {
        return JsonMap.filteredMap("javaMethod", this.javaMethod, "listener", this.listener, "outer", this.outer);
    }

    @FluentSetters
    public static class Builder
    extends BeanSession.Builder {
        Parser ctx;
        Method javaMethod;
        Object outer;
        HttpPartSchema schema;

        protected Builder(Parser ctx) {
            super(ctx.getBeanContext());
            this.ctx = ctx;
            this.mediaTypeDefault(ctx.getPrimaryMediaType());
        }

        @Override
        public ParserSession build() {
            return new ParserSession(this);
        }

        @FluentSetter
        public Builder javaMethod(Method value) {
            this.javaMethod = value;
            return this;
        }

        @FluentSetter
        public Builder outer(Object value) {
            this.outer = value;
            return this;
        }

        @FluentSetter
        public Builder schema(HttpPartSchema value) {
            if (value != null) {
                this.schema = value;
            }
            return this;
        }

        @FluentSetter
        public Builder schemaDefault(HttpPartSchema value) {
            if (value != null && this.schema == null) {
                this.schema = value;
            }
            return this;
        }

        @Override
        public <T> Builder apply(Class<T> type, Consumer<T> apply) {
            super.apply((Class)type, (Consumer)apply);
            return this;
        }

        @Override
        public Builder debug(Boolean value) {
            super.debug(value);
            return this;
        }

        @Override
        public Builder properties(Map<String, Object> value) {
            super.properties((Map)value);
            return this;
        }

        @Override
        public Builder property(String key, Object value) {
            super.property(key, value);
            return this;
        }

        @Override
        public Builder unmodifiable() {
            super.unmodifiable();
            return this;
        }

        @Override
        public Builder locale(Locale value) {
            super.locale(value);
            return this;
        }

        @Override
        public Builder localeDefault(Locale value) {
            super.localeDefault(value);
            return this;
        }

        @Override
        public Builder mediaType(MediaType value) {
            super.mediaType(value);
            return this;
        }

        @Override
        public Builder mediaTypeDefault(MediaType value) {
            super.mediaTypeDefault(value);
            return this;
        }

        @Override
        public Builder timeZone(TimeZone value) {
            super.timeZone(value);
            return this;
        }

        @Override
        public Builder timeZoneDefault(TimeZone value) {
            super.timeZoneDefault(value);
            return this;
        }
    }
}

