/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.objecttools;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.objecttools.ObjectTool;
import org.apache.juneau.objecttools.SortArgs;

public final class ObjectSorter
implements ObjectTool<SortArgs> {
    public static final ObjectSorter DEFAULT = new ObjectSorter();

    public static ObjectSorter create() {
        return new ObjectSorter();
    }

    public <R> List<R> run(Object input, String sortArgs) {
        Object r = this.run(BeanContext.DEFAULT_SESSION, input, SortArgs.create(sortArgs));
        if (r instanceof List) {
            return (List)r;
        }
        if (r instanceof Collection) {
            return new ArrayList((Collection)r);
        }
        if (r.getClass().isArray()) {
            return Arrays.asList((Object[])r);
        }
        return null;
    }

    @Override
    public Object run(BeanSession session, Object input, SortArgs args) {
        if (input == null) {
            return null;
        }
        Map<String, Boolean> sort = args.getSort();
        if (sort.isEmpty()) {
            return input;
        }
        ClassMeta<Object> type = session.getClassMetaForObject(input);
        if (!type.isCollectionOrArray()) {
            return input;
        }
        ArrayList<SortEntry> l = null;
        if (type.isArray()) {
            int size = Array.getLength(input);
            l = CollectionUtils.list(size);
            for (int i = 0; i < size; ++i) {
                l.add(new SortEntry(session, Array.get(input, i)));
            }
        } else {
            Collection c2 = (Collection)input;
            ArrayList<SortEntry> l2 = l = CollectionUtils.list(c2.size());
            c2.forEach(x -> l2.add(new SortEntry(session, x)));
        }
        ArrayList<String> columns = CollectionUtils.listFrom(sort.keySet());
        Collections.reverse(columns);
        ArrayList<SortEntry> l3 = l;
        columns.forEach(c -> {
            boolean isDesc = (Boolean)sort.get(c);
            l3.forEach(se -> se.setSort((String)c, isDesc));
            Collections.sort(l3);
        });
        ArrayList l2 = CollectionUtils.list(l.size());
        l.forEach(x -> l2.add(x.o));
        return l2;
    }

    private static class SortEntry
    implements Comparable {
        Object o;
        ClassMeta<?> cm;
        BeanSession bs;
        Object sortVal;
        boolean isDesc;

        SortEntry(BeanSession bs, Object o) {
            this.o = o;
            this.bs = bs;
            this.cm = bs.getClassMetaForObject(o);
        }

        void setSort(String sortCol, boolean isDesc) {
            this.isDesc = isDesc;
            this.sortVal = this.cm == null ? null : (this.cm.isMap() ? ((Map)this.o).get(sortCol) : (this.cm.isBean() ? this.bs.toBeanMap(this.o).get(sortCol) : null));
        }

        public int compareTo(Object o) {
            if (this.isDesc) {
                return ObjectUtils.compare(((SortEntry)o).sortVal, this.sortVal);
            }
            return ObjectUtils.compare(this.sortVal, ((SortEntry)o).sortVal);
        }
    }
}

