/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.assignor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.group.api.assignor.ConsumerGroupPartitionAssignor;
import org.apache.kafka.coordinator.group.api.assignor.GroupAssignment;
import org.apache.kafka.coordinator.group.api.assignor.GroupSpec;
import org.apache.kafka.coordinator.group.api.assignor.MemberSubscription;
import org.apache.kafka.coordinator.group.api.assignor.PartitionAssignorException;
import org.apache.kafka.coordinator.group.api.assignor.SubscribedTopicDescriber;
import org.apache.kafka.coordinator.group.api.assignor.SubscriptionType;
import org.apache.kafka.coordinator.group.assignor.RangeSet;
import org.apache.kafka.coordinator.group.modern.MemberAssignmentImpl;

public class RangeAssignor
implements ConsumerGroupPartitionAssignor {
    public static final String NAME = "range";

    public String name() {
        return NAME;
    }

    private GroupAssignment assignHomogeneousGroup(GroupSpec groupSpec, SubscribedTopicDescriber subscribedTopicDescriber) throws PartitionAssignorException {
        List<String> memberIds = this.sortMemberIds(groupSpec);
        int numMembers = groupSpec.memberIds().size();
        MemberSubscription subs = groupSpec.memberSubscription(memberIds.get(0));
        ArrayList<TopicMetadata> topics = new ArrayList<TopicMetadata>(subs.subscribedTopicIds().size());
        for (Uuid topicId : subs.subscribedTopicIds()) {
            int numPartitions = subscribedTopicDescriber.numPartitions(topicId);
            if (numPartitions == -1) {
                throw new PartitionAssignorException("Member is subscribed to a non-existent topic");
            }
            TopicMetadata m = new TopicMetadata(topicId, numPartitions, numMembers);
            topics.add(m);
        }
        HashMap<String, MemberAssignmentImpl> assignments = new HashMap<String, MemberAssignmentImpl>((int)((float)groupSpec.memberIds().size() / 0.75f + 1.0f));
        int memberAssignmentInitialCapacity = (int)((float)topics.size() / 0.75f + 1.0f);
        for (String memberId : memberIds) {
            HashMap<Uuid, Set<Integer>> assignment = new HashMap<Uuid, Set<Integer>>(memberAssignmentInitialCapacity);
            for (TopicMetadata topicMetadata : topics) {
                topicMetadata.maybeComputeQuota();
                this.addPartitionsToAssignment(topicMetadata, assignment);
            }
            assignments.put(memberId, new MemberAssignmentImpl(assignment));
        }
        return new GroupAssignment(assignments);
    }

    private GroupAssignment assignHeterogeneousGroup(GroupSpec groupSpec, SubscribedTopicDescriber subscribedTopicDescriber) throws PartitionAssignorException {
        List<String> memberIds = this.sortMemberIds(groupSpec);
        HashMap<Uuid, TopicMetadata> topics = new HashMap<Uuid, TopicMetadata>();
        for (String memberId : memberIds) {
            MemberSubscription subs = groupSpec.memberSubscription(memberId);
            for (Uuid topicId : subs.subscribedTopicIds()) {
                TopicMetadata topicMetadata = topics.computeIfAbsent(topicId, __ -> {
                    int numPartitions = subscribedTopicDescriber.numPartitions(topicId);
                    if (numPartitions == -1) {
                        throw new PartitionAssignorException("Member is subscribed to a non-existent topic");
                    }
                    return new TopicMetadata(topicId, numPartitions, 0);
                });
                ++topicMetadata.numMembers;
            }
        }
        HashMap<String, MemberAssignmentImpl> assignments = new HashMap<String, MemberAssignmentImpl>((int)((float)groupSpec.memberIds().size() / 0.75f + 1.0f));
        for (String memberId : memberIds) {
            MemberSubscription subs = groupSpec.memberSubscription(memberId);
            HashMap<Uuid, Set<Integer>> assignment = new HashMap<Uuid, Set<Integer>>((int)((float)subs.subscribedTopicIds().size() / 0.75f + 1.0f));
            for (Uuid topicId : subs.subscribedTopicIds()) {
                TopicMetadata metadata = (TopicMetadata)topics.get(topicId);
                metadata.maybeComputeQuota();
                this.addPartitionsToAssignment(metadata, assignment);
            }
            assignments.put(memberId, new MemberAssignmentImpl(assignment));
        }
        return new GroupAssignment(assignments);
    }

    private List<String> sortMemberIds(GroupSpec groupSpec) {
        ArrayList<String> sortedMemberIds = new ArrayList<String>(groupSpec.memberIds());
        sortedMemberIds.sort((memberId1, memberId2) -> {
            Optional instanceId1 = groupSpec.memberSubscription(memberId1).instanceId();
            Optional instanceId2 = groupSpec.memberSubscription(memberId2).instanceId();
            if (instanceId1.isPresent() && instanceId2.isPresent()) {
                return ((String)instanceId1.get()).compareTo((String)instanceId2.get());
            }
            if (instanceId1.isPresent()) {
                return -1;
            }
            if (instanceId2.isPresent()) {
                return 1;
            }
            return memberId1.compareTo((String)memberId2);
        });
        return sortedMemberIds;
    }

    private void addPartitionsToAssignment(TopicMetadata topicMetadata, Map<Uuid, Set<Integer>> memberAssignment) {
        int end;
        int start = topicMetadata.nextRange;
        int quota = topicMetadata.minQuota;
        if (topicMetadata.extraPartitions > 0) {
            ++quota;
            --topicMetadata.extraPartitions;
        }
        topicMetadata.nextRange = end = Math.min(start + quota, topicMetadata.numPartitions);
        if (start < end) {
            memberAssignment.put(topicMetadata.topicId, new RangeSet(start, end));
        }
    }

    public GroupAssignment assign(GroupSpec groupSpec, SubscribedTopicDescriber subscribedTopicDescriber) throws PartitionAssignorException {
        if (groupSpec.memberIds().isEmpty()) {
            return new GroupAssignment(Collections.emptyMap());
        }
        if (groupSpec.subscriptionType() == SubscriptionType.HOMOGENEOUS) {
            return this.assignHomogeneousGroup(groupSpec, subscribedTopicDescriber);
        }
        return this.assignHeterogeneousGroup(groupSpec, subscribedTopicDescriber);
    }

    private static class TopicMetadata {
        private final Uuid topicId;
        private final int numPartitions;
        private int numMembers;
        private int minQuota = -1;
        private int extraPartitions = -1;
        private int nextRange = 0;

        private TopicMetadata(Uuid topicId, int numPartitions, int numMembers) {
            this.topicId = topicId;
            this.numPartitions = numPartitions;
            this.numMembers = numMembers;
        }

        private void maybeComputeQuota() {
            if (this.minQuota != -1) {
                return;
            }
            this.minQuota = this.numPartitions / this.numMembers;
            this.extraPartitions = this.numPartitions % this.numMembers;
        }

        public String toString() {
            return "TopicMetadata(topicId=" + String.valueOf(this.topicId) + ", numPartitions=" + this.numPartitions + ", numMembers=" + this.numMembers + ", minQuota=" + this.minQuota + ", extraPartitions=" + this.extraPartitions + ", nextRange=" + this.nextRange + ")";
        }
    }
}

