/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.metadata.storage;

import java.io.Closeable;
import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.log.remote.metadata.storage.ConsumerTask;
import org.apache.kafka.server.log.remote.metadata.storage.RemoteLogMetadataTopicPartitioner;
import org.apache.kafka.server.log.remote.metadata.storage.RemotePartitionMetadataEventHandler;
import org.apache.kafka.server.log.remote.metadata.storage.TopicBasedRemoteLogMetadataManagerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerManager
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(ConsumerManager.class);
    private static final long CONSUME_RECHECK_INTERVAL_MS = 50L;
    private final TopicBasedRemoteLogMetadataManagerConfig rlmmConfig;
    private final Time time;
    private final ConsumerTask consumerTask;
    private final Thread consumerTaskThread;

    public ConsumerManager(TopicBasedRemoteLogMetadataManagerConfig rlmmConfig, RemotePartitionMetadataEventHandler remotePartitionMetadataEventHandler, RemoteLogMetadataTopicPartitioner topicPartitioner, Time time) {
        this.rlmmConfig = rlmmConfig;
        this.time = time;
        KafkaConsumer consumer = new KafkaConsumer(rlmmConfig.consumerProperties());
        this.consumerTask = new ConsumerTask(remotePartitionMetadataEventHandler, topicPartitioner, (Consumer<byte[], byte[]>)consumer, 100L, 300000L, time);
        this.consumerTaskThread = KafkaThread.nonDaemon((String)"RLMMConsumerTask", (Runnable)this.consumerTask);
    }

    public void startConsumerThread() {
        try {
            this.consumerTaskThread.start();
            log.info("RLMM Consumer task thread is started");
        }
        catch (Exception e) {
            throw new KafkaException("Error encountered while initializing and scheduling ConsumerTask thread", (Throwable)e);
        }
    }

    public void waitTillConsumptionCatchesUp(RecordMetadata recordMetadata) throws TimeoutException {
        this.waitTillConsumptionCatchesUp(recordMetadata, this.rlmmConfig.consumeWaitMs());
    }

    public void waitTillConsumptionCatchesUp(RecordMetadata recordMetadata, long timeoutMs) throws TimeoutException {
        int partition = recordMetadata.partition();
        if (!this.consumerTask.isMetadataPartitionAssigned(partition)) {
            throw new KafkaException("This consumer is not assigned to the target partition " + partition + ". Currently assigned partitions: " + String.valueOf(this.consumerTask.metadataPartitionsAssigned()));
        }
        long offset = recordMetadata.offset();
        long startTimeMs = this.time.milliseconds();
        long consumeCheckIntervalMs = Math.min(50L, timeoutMs);
        log.info("Wait until the consumer is caught up with the target partition {} up-to offset {}", (Object)partition, (Object)offset);
        long readOffset;
        while ((readOffset = this.consumerTask.readOffsetForMetadataPartition(partition).orElse(-1L).longValue()) < offset) {
            log.debug("Expected offset for partition {} is {}, but the read offset is {}. Sleeping for {} ms to retry again", new Object[]{partition, offset, readOffset, consumeCheckIntervalMs});
            if (this.time.milliseconds() - startTimeMs > timeoutMs) {
                log.warn("Expected offset for partition {} is {}, but the read offset is {}", new Object[]{partition, offset, readOffset});
                throw new TimeoutException("Timed out in catching up with the expected offset by consumer.");
            }
            this.time.sleep(consumeCheckIntervalMs);
        }
        return;
    }

    @Override
    public void close() throws IOException {
        Utils.closeQuietly((AutoCloseable)this.consumerTask, (String)"ConsumerTask");
        try {
            this.consumerTaskThread.join();
        }
        catch (Exception e) {
            log.error("Encountered error while waiting for consumerTaskThread to finish.", (Throwable)e);
        }
    }

    public void addAssignmentsForPartitions(Set<TopicIdPartition> partitions) {
        this.consumerTask.addAssignmentsForPartitions(partitions);
    }

    public void removeAssignmentsForPartitions(Set<TopicIdPartition> partitions) {
        this.consumerTask.removeAssignmentsForPartitions(partitions);
    }

    public Optional<Long> readOffsetForPartition(int metadataPartition) {
        return this.consumerTask.readOffsetForMetadataPartition(metadataPartition);
    }
}

