/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.examples.pageview;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.examples.pageview.JsonTimestampExtractor;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.Grouped;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Produced;
import org.apache.kafka.streams.kstream.TimeWindows;
import org.apache.kafka.streams.kstream.Windows;

public class PageViewTypedDemo {
    public static void main(String[] args) {
        Properties props = new Properties();
        props.put("application.id", "streams-pageview-typed");
        props.put("bootstrap.servers", "localhost:9092");
        props.put("default.timestamp.extractor", JsonTimestampExtractor.class);
        props.put("default.key.serde", JSONSerde.class);
        props.put("default.value.serde", JSONSerde.class);
        props.put("statestore.cache.max.bytes", (Object)0);
        props.put("commit.interval.ms", (Object)1000L);
        props.put("auto.offset.reset", "earliest");
        StreamsBuilder builder = new StreamsBuilder();
        KStream views = builder.stream("streams-pageview-input", Consumed.with((Serde)Serdes.String(), new JSONSerde()));
        KTable users = builder.table("streams-userprofile-input", Consumed.with((Serde)Serdes.String(), new JSONSerde()));
        Duration duration24Hours = Duration.ofHours(24L);
        KStream regionCount = views.leftJoin(users, (view, profile) -> {
            PageViewByRegion viewByRegion = new PageViewByRegion();
            viewByRegion.user = view.user;
            viewByRegion.page = view.page;
            viewByRegion.region = profile != null ? profile.region : "UNKNOWN";
            return viewByRegion;
        }).map((user, viewRegion) -> new KeyValue((Object)viewRegion.region, viewRegion)).groupByKey(Grouped.with((Serde)Serdes.String(), new JSONSerde())).windowedBy((Windows)TimeWindows.ofSizeAndGrace((Duration)Duration.ofDays(7L), (Duration)duration24Hours).advanceBy(Duration.ofSeconds(1L))).count().toStream().map((key, value) -> {
            WindowedPageViewByRegion wViewByRegion = new WindowedPageViewByRegion();
            wViewByRegion.windowStart = key.window().start();
            wViewByRegion.region = (String)key.key();
            RegionCount rCount = new RegionCount();
            rCount.region = (String)key.key();
            rCount.count = value;
            return new KeyValue((Object)wViewByRegion, (Object)rCount);
        });
        regionCount.to("streams-pageviewstats-typed-output", Produced.with(new JSONSerde(), new JSONSerde()));
        final KafkaStreams streams = new KafkaStreams(builder.build(), props);
        final CountDownLatch latch = new CountDownLatch(1);
        Runtime.getRuntime().addShutdownHook(new Thread("streams-pipe-shutdown-hook"){

            @Override
            public void run() {
                streams.close();
                latch.countDown();
            }
        });
        try {
            streams.start();
            latch.await();
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    public static class JSONSerde<T extends JSONSerdeCompatible>
    implements Serializer<T>,
    Deserializer<T>,
    Serde<T> {
        private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

        public void configure(Map<String, ?> configs, boolean isKey) {
        }

        public T deserialize(String topic, byte[] data) {
            if (data == null) {
                return null;
            }
            try {
                return (T)((JSONSerdeCompatible)OBJECT_MAPPER.readValue(data, JSONSerdeCompatible.class));
            }
            catch (IOException e) {
                throw new SerializationException((Throwable)e);
            }
        }

        public byte[] serialize(String topic, T data) {
            if (data == null) {
                return null;
            }
            try {
                return OBJECT_MAPPER.writeValueAsBytes(data);
            }
            catch (Exception e) {
                throw new SerializationException("Error serializing JSON message", (Throwable)e);
            }
        }

        public void close() {
        }

        public Serializer<T> serializer() {
            return this;
        }

        public Deserializer<T> deserializer() {
            return this;
        }
    }

    public static class WindowedPageViewByRegion
    implements JSONSerdeCompatible {
        public long windowStart;
        public String region;
    }

    public static class RegionCount
    implements JSONSerdeCompatible {
        public long count;
        public String region;
    }

    public static class PageViewByRegion
    implements JSONSerdeCompatible {
        public String user;
        public String page;
        public String region;
    }

    public static class PageView
    implements JSONSerdeCompatible {
        public String user;
        public String page;
        public Long timestamp;
    }

    public static class UserProfile
    implements JSONSerdeCompatible {
        public String region;
        public Long timestamp;
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="_t")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=PageView.class, name="pv"), @JsonSubTypes.Type(value=UserProfile.class, name="up"), @JsonSubTypes.Type(value=PageViewByRegion.class, name="pvbr"), @JsonSubTypes.Type(value=WindowedPageViewByRegion.class, name="wpvbr"), @JsonSubTypes.Type(value=RegionCount.class, name="rc")})
    public static interface JSONSerdeCompatible {
    }
}

