/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import kafka.tools.DumpLogSegments;
import org.apache.kafka.common.message.KRaftVersionRecord;
import org.apache.kafka.common.message.KRaftVersionRecordJsonConverter;
import org.apache.kafka.common.message.LeaderChangeMessage;
import org.apache.kafka.common.message.LeaderChangeMessageJsonConverter;
import org.apache.kafka.common.message.SnapshotFooterRecord;
import org.apache.kafka.common.message.SnapshotFooterRecordJsonConverter;
import org.apache.kafka.common.message.SnapshotHeaderRecord;
import org.apache.kafka.common.message.SnapshotHeaderRecordJsonConverter;
import org.apache.kafka.common.message.VotersRecord;
import org.apache.kafka.common.message.VotersRecordJsonConverter;
import org.apache.kafka.common.record.AbstractLegacyRecordBatch;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.ControlRecordUtils;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.server.util.CommandDefaultOptions;
import org.apache.kafka.server.util.CommandLineUtils;
import org.apache.kafka.snapshot.SnapshotPath;
import org.apache.kafka.snapshot.Snapshots;
import org.apache.kafka.storage.internals.log.CorruptSnapshotException;
import org.apache.kafka.storage.internals.log.LogFileUtils;
import org.apache.kafka.storage.internals.log.OffsetIndex;
import org.apache.kafka.storage.internals.log.OffsetPosition;
import org.apache.kafka.storage.internals.log.ProducerStateManager;
import org.apache.kafka.storage.internals.log.TimeIndex;
import org.apache.kafka.storage.internals.log.TimestampOffset;
import org.apache.kafka.storage.internals.log.TransactionIndex;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class DumpLogSegments$ {
    public static final DumpLogSegments$ MODULE$ = new DumpLogSegments$();
    private static final String RecordIndent = "|";

    public String RecordIndent() {
        return RecordIndent;
    }

    public void main(String[] args) {
        DumpLogSegments.DumpLogSegmentsOptions opts = new DumpLogSegments.DumpLogSegmentsOptions(args);
        CommandLineUtils.maybePrintHelpOrVersion((CommandDefaultOptions)opts, (String)"This tool helps to parse a log file and dump its contents to the console, useful for debugging a seemingly corrupt log segment.");
        opts.checkArgs();
        Map misMatchesForIndexFilesMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors = new DumpLogSegments.TimeIndexDumpErrors();
        Map nonConsecutivePairsForLogFilesMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])opts.files()), (Function1 & Serializable)arg -> {
            DumpLogSegments$.$anonfun$main$1(opts, nonConsecutivePairsForLogFilesMap, misMatchesForIndexFilesMap, timeIndexDumpErrors, arg);
            return BoxedUnit.UNIT;
        });
        misMatchesForIndexFilesMap.foreachEntry((Function2 & Serializable)(fileName, listOfMismatches) -> {
            DumpLogSegments$.$anonfun$main$2(fileName, listOfMismatches);
            return BoxedUnit.UNIT;
        });
        timeIndexDumpErrors.printErrors();
        nonConsecutivePairsForLogFilesMap.foreachEntry((Function2 & Serializable)(fileName, listOfNonConsecutivePairs) -> {
            DumpLogSegments$.$anonfun$main$4(fileName, listOfNonConsecutivePairs);
            return BoxedUnit.UNIT;
        });
    }

    private void dumpTxnIndex(File file) {
        TransactionIndex index = new TransactionIndex(LogFileUtils.offsetFromFile((File)file).longValue(), file);
        CollectionConverters$.MODULE$.ListHasAsScala(index.allAbortedTxns()).asScala().foreach((Function1 & Serializable)abortedTxn -> {
            Predef$.MODULE$.println((Object)("version: " + abortedTxn.version() + " producerId: " + abortedTxn.producerId() + " firstOffset: " + abortedTxn.firstOffset() + " lastOffset: " + abortedTxn.lastOffset() + " lastStableOffset: " + abortedTxn.lastStableOffset()));
            return BoxedUnit.UNIT;
        });
    }

    private void dumpProducerIdSnapshot(File file) {
        try {
            ProducerStateManager.readSnapshot((File)file).forEach(entry -> {
                Predef$.MODULE$.print((Object)("producerId: " + entry.producerId() + " producerEpoch: " + entry.producerEpoch() + " coordinatorEpoch: " + entry.coordinatorEpoch() + " currentTxnFirstOffset: " + entry.currentTxnFirstOffset() + " lastTimestamp: " + entry.lastTimestamp() + " "));
                CollectionConverters$.MODULE$.CollectionHasAsScala(entry.batchMetadata()).asScala().headOption().foreach((Function1 & Serializable)metadata -> {
                    Predef$.MODULE$.print((Object)("firstSequence: " + metadata.firstSeq() + " lastSequence: " + metadata.lastSeq + " lastOffset: " + metadata.lastOffset + " offsetDelta: " + metadata.offsetDelta + " timestamp: " + metadata.timestamp));
                    return BoxedUnit.UNIT;
                });
                Predef$.MODULE$.println();
            });
            return;
        }
        catch (CorruptSnapshotException e) {
            System.err.println(e.getMessage());
            return;
        }
    }

    public void dumpIndex(File file, boolean indexSanityOnly, boolean verifyOnly, Map<String, List<Tuple2<Object, Object>>> misMatchesForIndexFilesMap, int maxMessageSize) {
        Object object = new Object();
        try {
            long startOffset = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(file.getName().split("\\.")[0]));
            File logFile = new File(file.getAbsoluteFile().getParent(), file.getName().split("\\.")[0] + ".log");
            boolean open_mutable = false;
            FileRecords fileRecords = FileRecords.open((File)logFile, (boolean)open_mutable, (boolean)false, (int)0, (boolean)false);
            OffsetIndex index = new OffsetIndex(file, startOffset, -1, false);
            if (index.entries() == 0) {
                Predef$.MODULE$.println((Object)(file + " is empty."));
                return;
            }
            if (indexSanityOnly) {
                index.sanityCheck();
                Predef$.MODULE$.println((Object)(file + " passed sanity check."));
                return;
            }
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), index.entries()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                OffsetPosition entry = index.entry(i);
                if (entry.offset == index.baseOffset() && i > 0) {
                    throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                }
                long firstBatchLastOffset = ((RecordBatch)fileRecords.slice(entry.position, maxMessageSize).batches().iterator().next()).lastOffset();
                if (firstBatchLastOffset != entry.offset) {
                    List misMatchesSeq = (List)misMatchesForIndexFilesMap.getOrElse((Object)file.getAbsolutePath(), (Function0 & Serializable)() -> Nil$.MODULE$);
                    misMatchesSeq = misMatchesSeq.$colon$colon((Object)new Tuple2.mcJJ.sp(entry.offset, firstBatchLastOffset));
                    misMatchesForIndexFilesMap.put((Object)file.getAbsolutePath(), (Object)misMatchesSeq);
                }
                if (!verifyOnly) {
                    Predef$.MODULE$.println((Object)("offset: " + entry.offset + " position: " + entry.position));
                    return;
                }
            });
            return;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
                return;
            }
            throw ex;
        }
    }

    public void dumpTimeIndex(File file, boolean indexSanityOnly, boolean verifyOnly, DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors) {
        Object object = new Object();
        try {
            block8: {
                block7: {
                    long startOffset = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(file.getName().split("\\.")[0]));
                    File logFile = new File(file.getAbsoluteFile().getParent(), file.getName().split("\\.")[0] + ".log");
                    boolean open_mutable = false;
                    FileRecords fileRecords = FileRecords.open((File)logFile, (boolean)open_mutable, (boolean)false, (int)0, (boolean)false);
                    File indexFile = new File(file.getAbsoluteFile().getParent(), file.getName().split("\\.")[0] + ".index");
                    OffsetIndex index = new OffsetIndex(indexFile, startOffset, -1, false);
                    TimeIndex timeIndex = new TimeIndex(file, startOffset, -1, false);
                    try {
                        if (indexSanityOnly) {
                            timeIndex.sanityCheck();
                            Predef$.MODULE$.println((Object)(file + " passed sanity check."));
                            break block7;
                        }
                        LongRef prevTimestamp = LongRef.create((long)-1L);
                        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), timeIndex.entries()).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> DumpLogSegments$.$anonfun$dumpTimeIndex$1(timeIndex, object, index, fileRecords, timeIndexDumpErrors, file, prevTimestamp, verifyOnly, arg_0)));
                        break block8;
                    }
                    finally {
                        fileRecords.closeHandlers();
                        index.closeHandler();
                        timeIndex.closeHandler();
                    }
                }
                return;
            }
            return;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
                return;
            }
            throw ex;
        }
    }

    private void dumpLog(File file, boolean printContents, Map<String, List<Tuple2<Object, Object>>> nonConsecutivePairsForLogFilesMap, boolean isDeepIteration, DumpLogSegments.MessageParser<?, ?> parser, boolean skipRecordMetadata, int maxBytes) {
        if (file.getName().endsWith(".log")) {
            long startOffset = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(file.getName().split("\\.")[0]));
            Predef$.MODULE$.println((Object)("Log starting offset: " + startOffset));
        } else if (file.getName().endsWith(".checkpoint")) {
            String string = file.getName();
            String string2 = "bootstrap.checkpoint";
            if (string != null && string.equals(string2)) {
                Predef$.MODULE$.println((Object)"KRaft bootstrap snapshot");
            } else {
                SnapshotPath path = (SnapshotPath)Snapshots.parse((Path)file.toPath()).get();
                Predef$.MODULE$.println((Object)("Snapshot end offset: " + path.snapshotId().offset() + ", epoch: " + path.snapshotId().epoch()));
            }
        }
        boolean open_mutable = false;
        FileRecords fileRecords = FileRecords.open((File)file, (boolean)open_mutable, (boolean)false, (int)0, (boolean)false).slice(0, maxBytes);
        try {
            LongRef validBytes = LongRef.create((long)0L);
            LongRef lastOffset = LongRef.create((long)-1L);
            CollectionConverters$.MODULE$.IterableHasAsScala(fileRecords.batches()).asScala().foreach((Function1 & Serializable)batch -> {
                DumpLogSegments$.$anonfun$dumpLog$1(validBytes, isDeepIteration, lastOffset, nonConsecutivePairsForLogFilesMap, file, skipRecordMetadata, printContents, parser, batch);
                return BoxedUnit.UNIT;
            });
            long trailingBytes = (long)fileRecords.sizeInBytes() - validBytes.elem;
            if (trailingBytes > 0L && maxBytes == Integer.MAX_VALUE) {
                Predef$.MODULE$.println((Object)("Found " + trailingBytes + " invalid bytes at the end of " + file.getName()));
            }
        }
        finally {
            fileRecords.closeHandlers();
        }
    }

    private void printControlRecord(Record record) {
        short controlTypeId = ControlRecordType.parseTypeId((ByteBuffer)record.key());
        ControlRecordType controlRecordType = ControlRecordType.fromTypeId((short)controlTypeId);
        if (ControlRecordType.ABORT.equals(controlRecordType) ? true : ControlRecordType.COMMIT.equals(controlRecordType)) {
            EndTransactionMarker endTxnMarker = EndTransactionMarker.deserialize((Record)record);
            Predef$.MODULE$.print((Object)(" endTxnMarker: " + endTxnMarker.controlType() + " coordinatorEpoch: " + endTxnMarker.coordinatorEpoch()));
            return;
        }
        if (ControlRecordType.LEADER_CHANGE.equals(controlRecordType)) {
            LeaderChangeMessage leaderChangeMessage = ControlRecordUtils.deserializeLeaderChangeMessage((Record)record);
            short write__version = leaderChangeMessage.version();
            Predef$.MODULE$.print((Object)(" LeaderChange: " + LeaderChangeMessageJsonConverter.write((LeaderChangeMessage)leaderChangeMessage, (short)write__version, (boolean)true)));
            return;
        }
        if (ControlRecordType.SNAPSHOT_HEADER.equals(controlRecordType)) {
            SnapshotHeaderRecord header = ControlRecordUtils.deserializeSnapshotHeaderRecord((Record)record);
            short write__version = header.version();
            Predef$.MODULE$.print((Object)(" SnapshotHeader " + SnapshotHeaderRecordJsonConverter.write((SnapshotHeaderRecord)header, (short)write__version, (boolean)true)));
            return;
        }
        if (ControlRecordType.SNAPSHOT_FOOTER.equals(controlRecordType)) {
            SnapshotFooterRecord footer = ControlRecordUtils.deserializeSnapshotFooterRecord((Record)record);
            short write__version = footer.version();
            Predef$.MODULE$.print((Object)(" SnapshotFooter " + SnapshotFooterRecordJsonConverter.write((SnapshotFooterRecord)footer, (short)write__version, (boolean)true)));
            return;
        }
        if (ControlRecordType.KRAFT_VERSION.equals(controlRecordType)) {
            KRaftVersionRecord kraftVersion = ControlRecordUtils.deserializeKRaftVersionRecord((Record)record);
            short write__version = kraftVersion.version();
            Predef$.MODULE$.print((Object)(" KRaftVersion " + KRaftVersionRecordJsonConverter.write((KRaftVersionRecord)kraftVersion, (short)write__version, (boolean)true)));
            return;
        }
        if (ControlRecordType.KRAFT_VOTERS.equals(controlRecordType)) {
            VotersRecord voters = ControlRecordUtils.deserializeVotersRecord((Record)record);
            short write__version = voters.version();
            Predef$.MODULE$.print((Object)(" KRaftVoters " + VotersRecordJsonConverter.write((VotersRecord)voters, (short)write__version, (boolean)true)));
            return;
        }
        Predef$.MODULE$.print((Object)(" controlType: " + controlRecordType + "(" + controlTypeId + ")"));
    }

    private void printBatchLevel(FileLogInputStream.FileChannelRecordBatch batch, long accumulativeBytes) {
        if (batch.magic() >= 2) {
            Predef$.MODULE$.print((Object)("baseOffset: " + batch.baseOffset() + " lastOffset: " + batch.lastOffset() + " count: " + batch.countOrNull() + " baseSequence: " + batch.baseSequence() + " lastSequence: " + batch.lastSequence() + " producerId: " + batch.producerId() + " producerEpoch: " + batch.producerEpoch() + " partitionLeaderEpoch: " + batch.partitionLeaderEpoch() + " isTransactional: " + batch.isTransactional() + " isControl: " + batch.isControlBatch() + " deleteHorizonMs: " + batch.deleteHorizonMs()));
        } else {
            Predef$.MODULE$.print((Object)("offset: " + batch.lastOffset()));
        }
        Predef$.MODULE$.println((Object)(" position: " + accumulativeBytes + " " + batch.timestampType() + ": " + batch.maxTimestamp() + " size: " + batch.sizeInBytes() + " magic: " + batch.magic() + " compresscodec: " + batch.compressionType().name + " crc: " + batch.checksum() + " isvalid: " + batch.isValid()));
    }

    public static final /* synthetic */ void $anonfun$main$1(DumpLogSegments.DumpLogSegmentsOptions opts$1, Map nonConsecutivePairsForLogFilesMap$1, Map misMatchesForIndexFilesMap$1, DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors$1, String arg) {
        File file;
        block14: {
            file = new File(arg);
            Predef$.MODULE$.println((Object)("Dumping " + file));
            String filename = file.getName();
            String suffix = filename.substring(filename.lastIndexOf("."));
            switch (suffix == null ? 0 : suffix.hashCode()) {
                case -1558154186: {
                    if (".checkpoint".equals(suffix)) {
                        break;
                    }
                    break block14;
                }
                case -1253652494: {
                    if (".snapshot".equals(suffix)) {
                        MODULE$.dumpProducerIdSnapshot(file);
                        return;
                    }
                    break block14;
                }
                case -403971657: {
                    if (".timeindex".equals(suffix)) {
                        MODULE$.dumpTimeIndex(file, opts$1.indexSanityOnly(), opts$1.verifyOnly(), timeIndexDumpErrors$1);
                        return;
                    }
                    break block14;
                }
                case 1477718: {
                    if (".log".equals(suffix)) {
                        break;
                    }
                    break block14;
                }
                case 1139821270: {
                    if (".txnindex".equals(suffix)) {
                        MODULE$.dumpTxnIndex(file);
                        return;
                    }
                    break block14;
                }
                case 1417287012: {
                    if (".index".equals(suffix)) {
                        MODULE$.dumpIndex(file, opts$1.indexSanityOnly(), opts$1.verifyOnly(), (Map<String, List<Tuple2<Object, Object>>>)misMatchesForIndexFilesMap$1, opts$1.maxMessageSize());
                        return;
                    }
                    break block14;
                }
                default: {
                    break block14;
                }
            }
            MODULE$.dumpLog(file, opts$1.shouldPrintDataLog(), (Map<String, List<Tuple2<Object, Object>>>)nonConsecutivePairsForLogFilesMap$1, opts$1.isDeepIteration(), opts$1.messageParser(), opts$1.skipRecordMetadata(), opts$1.maxBytes());
            return;
        }
        System.err.println("Ignoring unknown file " + file);
    }

    public static final /* synthetic */ void $anonfun$main$3(Tuple2 x0$1) {
        if (x0$1 != null) {
            long indexOffset = x0$1._1$mcJ$sp();
            long logOffset = x0$1._2$mcJ$sp();
            System.err.println("  Index offset: " + indexOffset + ", log offset: " + logOffset);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$main$2(String fileName, List listOfMismatches) {
        System.err.println("Mismatches in :" + fileName);
        listOfMismatches.foreach((Function1 & Serializable)x0$1 -> {
            DumpLogSegments$.$anonfun$main$3(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$main$5(Tuple2 x0$2) {
        if (x0$2 != null) {
            long first = x0$2._1$mcJ$sp();
            long second = x0$2._2$mcJ$sp();
            System.err.println("  " + first + " is followed by " + second);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$main$4(String fileName, List listOfNonConsecutivePairs) {
        System.err.println("Non-consecutive offsets in " + fileName);
        listOfNonConsecutivePairs.foreach((Function1 & Serializable)x0$2 -> {
            DumpLogSegments$.$anonfun$main$5(x0$2);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$dumpTimeIndex$2(TimestampOffset entry$1, FileLogInputStream.FileChannelRecordBatch x$1) {
        return x$1.lastOffset() >= entry$1.offset;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$dumpTimeIndex$1(TimeIndex timeIndex$1, Object nonLocalReturnKey2$1, OffsetIndex index$2, FileRecords fileRecords$2, DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors$2, File file$2, LongRef prevTimestamp$1, boolean verifyOnly$2, int i) {
        block9: {
            block8: {
                entry = timeIndex$1.entry(i);
                if (entry.offset == timeIndex$1.baseOffset() && i > 0) {
                    throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey2$1, BoxedUnit.UNIT);
                }
                position = index$2.lookup((long)entry.offset).position;
                partialFileRecords = fileRecords$2.slice(position, 0x7FFFFFFF);
                batches = CollectionConverters$.MODULE$.IterableHasAsScala(partialFileRecords.batches()).asScala();
                maxTimestamp = LongRef.create((long)-1L);
                var14_14 = false;
                var15_15 = null;
                var16_16 = batches.find((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$dumpTimeIndex$2$adapted(org.apache.kafka.storage.internals.log.TimestampOffset org.apache.kafka.common.record.FileLogInputStream$FileChannelRecordBatch ), (Lorg/apache/kafka/common/record/FileLogInputStream$FileChannelRecordBatch;)Ljava/lang/Object;)((TimestampOffset)entry));
                if (!None$.MODULE$.equals(var16_16)) break block8;
                timeIndexDumpErrors$2.recordShallowOffsetNotFound(file$2, entry.offset, -1L);
                break block9;
            }
            if (!(var16_16 instanceof Some)) ** GOTO lbl-1000
            var14_14 = true;
            var15_15 = (Some)var16_16;
            batch = (FileLogInputStream.FileChannelRecordBatch)var15_15.value();
            if (batch.lastOffset() != entry.offset) {
                timeIndexDumpErrors$2.recordShallowOffsetNotFound(file$2, entry.offset, batch.lastOffset());
            } else if (var14_14) {
                batch = (FileLogInputStream.FileChannelRecordBatch)var15_15.value();
                CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)batch).asScala().foreach((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$dumpTimeIndex$3$adapted(scala.runtime.LongRef org.apache.kafka.common.record.Record ), (Lorg/apache/kafka/common/record/Record;)Ljava/lang/Object;)((LongRef)maxTimestamp));
                if (maxTimestamp.elem != entry.timestamp) {
                    timeIndexDumpErrors$2.recordMismatchTimeIndex(file$2, entry.timestamp, maxTimestamp.elem);
                }
                if (prevTimestamp$1.elem >= entry.timestamp) {
                    timeIndexDumpErrors$2.recordOutOfOrderIndexTimestamp(file$2, entry.timestamp, prevTimestamp$1.elem);
                }
            } else {
                throw new MatchError((Object)var16_16);
            }
        }
        if (!verifyOnly$2) {
            Predef$.MODULE$.println((Object)("timestamp: " + entry.timestamp + " offset: " + entry.offset));
        }
        prevTimestamp$1.elem = entry.timestamp;
    }

    public static final /* synthetic */ void $anonfun$dumpLog$5(ObjectRef prefix$1, Object key) {
        Predef$.MODULE$.print((Object)((String)prefix$1.elem + "key: " + key));
        prefix$1.elem = " ";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$dumpLog$2(LongRef lastOffset$1, Map nonConsecutivePairsForLogFilesMap$2, File file$3, boolean skipRecordMetadata$1, FileLogInputStream.FileChannelRecordBatch batch$1, boolean printContents$1, DumpLogSegments.MessageParser parser$1, Record record) {
        if (lastOffset$1.elem == -1L) {
            lastOffset$1.elem = record.offset();
        } else if (record.offset() != lastOffset$1.elem + 1L) {
            List nonConsecutivePairsSeq = (List)nonConsecutivePairsForLogFilesMap$2.getOrElse((Object)file$3.getAbsolutePath(), (Function0 & Serializable)() -> Nil$.MODULE$);
            nonConsecutivePairsSeq = nonConsecutivePairsSeq.$colon$colon((Object)new Tuple2.mcJJ.sp(lastOffset$1.elem, record.offset()));
            nonConsecutivePairsForLogFilesMap$2.put((Object)file$3.getAbsolutePath(), (Object)nonConsecutivePairsSeq);
        }
        lastOffset$1.elem = record.offset();
        ObjectRef prefix = ObjectRef.create((Object)(MODULE$.RecordIndent() + " "));
        if (!skipRecordMetadata$1) {
            Predef$.MODULE$.print((Object)((String)prefix.elem + "offset: " + record.offset() + " " + batch$1.timestampType() + ": " + record.timestamp() + " keySize: " + record.keySize() + " valueSize: " + record.valueSize()));
            prefix.elem = " ";
            if (batch$1.magic() >= 2) {
                Predef$.MODULE$.print((Object)(" sequence: " + record.sequence() + " headerKeys: " + Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])record.headers()), (Function1 & Serializable)x$2 -> x$2.key(), ClassTag$.MODULE$.apply(String.class))).mkString("[", ",", "]")));
            }
            if (record instanceof AbstractLegacyRecordBatch) {
                AbstractLegacyRecordBatch abstractLegacyRecordBatch = (AbstractLegacyRecordBatch)record;
                Predef$.MODULE$.print((Object)(" isValid: " + abstractLegacyRecordBatch.isValid() + " crc: " + abstractLegacyRecordBatch.checksum() + "}"));
            }
            if (batch$1.isControlBatch()) {
                MODULE$.printControlRecord(record);
            }
        }
        if (printContents$1 && !batch$1.isControlBatch()) {
            void var13_13;
            void var12_12;
            Tuple2 tuple2 = parser$1.parse(record);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Option key2 = (Option)tuple2._1();
            Option payload2 = (Option)tuple2._2();
            var12_12.foreach((Function1 & Serializable)key -> {
                DumpLogSegments$.$anonfun$dumpLog$5(prefix, key);
                return BoxedUnit.UNIT;
            });
            var13_13.foreach((Function1 & Serializable)payload -> {
                Predef$.MODULE$.print((Object)(" payload: " + payload));
                return BoxedUnit.UNIT;
            });
        }
        Predef$.MODULE$.println();
    }

    public static final /* synthetic */ void $anonfun$dumpLog$1(LongRef validBytes$1, boolean isDeepIteration$1, LongRef lastOffset$1, Map nonConsecutivePairsForLogFilesMap$2, File file$3, boolean skipRecordMetadata$1, boolean printContents$1, DumpLogSegments.MessageParser parser$1, FileLogInputStream.FileChannelRecordBatch batch) {
        MODULE$.printBatchLevel(batch, validBytes$1.elem);
        if (isDeepIteration$1) {
            CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)batch).asScala().foreach((Function1 & Serializable)record -> {
                DumpLogSegments$.$anonfun$dumpLog$2(lastOffset$1, nonConsecutivePairsForLogFilesMap$2, file$3, skipRecordMetadata$1, batch, printContents$1, parser$1, record);
                return BoxedUnit.UNIT;
            });
        }
        validBytes$1.elem += (long)batch.sizeInBytes();
    }

    private DumpLogSegments$() {
    }

    public static final /* synthetic */ Object $anonfun$dumpTimeIndex$2$adapted(TimestampOffset entry$1, FileLogInputStream.FileChannelRecordBatch x$1) {
        return BoxesRunTime.boxToBoolean((boolean)DumpLogSegments$.$anonfun$dumpTimeIndex$2(entry$1, x$1));
    }

    public static final /* synthetic */ Object $anonfun$dumpTimeIndex$3$adapted(LongRef maxTimestamp$1, Record record) {
        maxTimestamp$1.elem = package$.MODULE$.max(maxTimestamp$1.elem, record.timestamp());
        return BoxedUnit.UNIT;
    }
}

