/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.internals.CoordinatorKey;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public class ListShareGroupOffsetsResult {
    private final Map<String, KafkaFuture<Map<TopicPartition, OffsetAndMetadata>>> futures;

    ListShareGroupOffsetsResult(Map<CoordinatorKey, KafkaFuture<Map<TopicPartition, OffsetAndMetadata>>> futures) {
        this.futures = futures.entrySet().stream().collect(Collectors.toMap(e -> ((CoordinatorKey)e.getKey()).idValue, Map.Entry::getValue));
    }

    public KafkaFuture<Map<String, Map<TopicPartition, OffsetAndMetadata>>> all() {
        return KafkaFuture.allOf(this.futures.values().toArray(new KafkaFuture[0])).thenApply(nil -> {
            HashMap offsets = new HashMap(this.futures.size());
            this.futures.forEach((groupId, future) -> {
                try {
                    offsets.put(groupId, (Map)future.get());
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            });
            return offsets;
        });
    }

    public KafkaFuture<Map<TopicPartition, OffsetAndMetadata>> partitionsToOffsetAndMetadata(String groupId) {
        if (!this.futures.containsKey(groupId)) {
            throw new IllegalArgumentException("Group ID not found: " + groupId);
        }
        return this.futures.get(groupId);
    }
}

