/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams;

import java.util.Objects;
import org.apache.kafka.streams.state.QueryableStoreType;

public class StoreQueryParameters<T> {
    private final Integer partition;
    private final boolean staleStores;
    private final String storeName;
    private final QueryableStoreType<T> queryableStoreType;

    protected StoreQueryParameters(String storeName, QueryableStoreType<T> queryableStoreType, Integer partition, boolean staleStores) {
        this.storeName = storeName;
        this.queryableStoreType = queryableStoreType;
        this.partition = partition;
        this.staleStores = staleStores;
    }

    public static <T> StoreQueryParameters<T> fromNameAndType(String storeName, QueryableStoreType<T> queryableStoreType) {
        return new StoreQueryParameters<T>(storeName, queryableStoreType, null, false);
    }

    public StoreQueryParameters<T> withPartition(Integer partition) {
        return new StoreQueryParameters<T>(this.storeName, this.queryableStoreType, partition, this.staleStores);
    }

    public StoreQueryParameters<T> enableStaleStores() {
        return new StoreQueryParameters<T>(this.storeName, this.queryableStoreType, this.partition, true);
    }

    public String storeName() {
        return this.storeName;
    }

    public QueryableStoreType<T> queryableStoreType() {
        return this.queryableStoreType;
    }

    public Integer partition() {
        return this.partition;
    }

    public boolean staleStoresEnabled() {
        return this.staleStores;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StoreQueryParameters)) {
            return false;
        }
        StoreQueryParameters storeQueryParameters = (StoreQueryParameters)obj;
        return Objects.equals(storeQueryParameters.partition, this.partition) && Objects.equals(storeQueryParameters.staleStores, this.staleStores) && Objects.equals(storeQueryParameters.storeName, this.storeName) && Objects.equals(storeQueryParameters.queryableStoreType, this.queryableStoreType);
    }

    public String toString() {
        return "StoreQueryParameters {partition=" + this.partition + ", staleStores=" + this.staleStores + ", storeName=" + this.storeName + ", queryableStoreType=" + String.valueOf(this.queryableStoreType) + "}";
    }

    public int hashCode() {
        return Objects.hash(this.partition, this.staleStores, this.storeName, this.queryableStoreType);
    }
}

