/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.BranchedKStream;
import org.apache.kafka.streams.kstream.ForeachAction;
import org.apache.kafka.streams.kstream.GlobalKTable;
import org.apache.kafka.streams.kstream.Grouped;
import org.apache.kafka.streams.kstream.JoinWindows;
import org.apache.kafka.streams.kstream.Joined;
import org.apache.kafka.streams.kstream.KGroupedStream;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.Named;
import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.streams.kstream.Printed;
import org.apache.kafka.streams.kstream.Produced;
import org.apache.kafka.streams.kstream.Repartitioned;
import org.apache.kafka.streams.kstream.StreamJoined;
import org.apache.kafka.streams.kstream.ValueJoiner;
import org.apache.kafka.streams.kstream.ValueJoinerWithKey;
import org.apache.kafka.streams.kstream.ValueMapper;
import org.apache.kafka.streams.kstream.ValueMapperWithKey;
import org.apache.kafka.streams.processor.TopicNameExtractor;
import org.apache.kafka.streams.processor.api.FixedKeyProcessorSupplier;
import org.apache.kafka.streams.processor.api.ProcessorSupplier;
import org.apache.kafka.streams.state.KeyValueStore;

public interface KStream<K, V> {
    public KStream<K, V> filter(Predicate<? super K, ? super V> var1);

    public KStream<K, V> filter(Predicate<? super K, ? super V> var1, Named var2);

    public KStream<K, V> filterNot(Predicate<? super K, ? super V> var1);

    public KStream<K, V> filterNot(Predicate<? super K, ? super V> var1, Named var2);

    public <KOut> KStream<KOut, V> selectKey(KeyValueMapper<? super K, ? super V, ? extends KOut> var1);

    public <KOut> KStream<KOut, V> selectKey(KeyValueMapper<? super K, ? super V, ? extends KOut> var1, Named var2);

    public <VOut> KStream<K, VOut> mapValues(ValueMapper<? super V, ? extends VOut> var1);

    public <VOut> KStream<K, VOut> mapValues(ValueMapper<? super V, ? extends VOut> var1, Named var2);

    public <VOut> KStream<K, VOut> mapValues(ValueMapperWithKey<? super K, ? super V, ? extends VOut> var1);

    public <VOut> KStream<K, VOut> mapValues(ValueMapperWithKey<? super K, ? super V, ? extends VOut> var1, Named var2);

    public <KOut, VOut> KStream<KOut, VOut> map(KeyValueMapper<? super K, ? super V, ? extends KeyValue<? extends KOut, ? extends VOut>> var1);

    public <KOut, VOut> KStream<KOut, VOut> map(KeyValueMapper<? super K, ? super V, ? extends KeyValue<? extends KOut, ? extends VOut>> var1, Named var2);

    public <KOut, VOut> KStream<KOut, VOut> flatMap(KeyValueMapper<? super K, ? super V, ? extends Iterable<? extends KeyValue<? extends KOut, ? extends VOut>>> var1);

    public <KR, VOut> KStream<KR, VOut> flatMap(KeyValueMapper<? super K, ? super V, ? extends Iterable<? extends KeyValue<? extends KR, ? extends VOut>>> var1, Named var2);

    public <VOut> KStream<K, VOut> flatMapValues(ValueMapper<? super V, ? extends Iterable<? extends VOut>> var1);

    public <VOut> KStream<K, VOut> flatMapValues(ValueMapper<? super V, ? extends Iterable<? extends VOut>> var1, Named var2);

    public <VOut> KStream<K, VOut> flatMapValues(ValueMapperWithKey<? super K, ? super V, ? extends Iterable<? extends VOut>> var1);

    public <VOut> KStream<K, VOut> flatMapValues(ValueMapperWithKey<? super K, ? super V, ? extends Iterable<? extends VOut>> var1, Named var2);

    public void print(Printed<K, V> var1);

    public void foreach(ForeachAction<? super K, ? super V> var1);

    public void foreach(ForeachAction<? super K, ? super V> var1, Named var2);

    public KStream<K, V> peek(ForeachAction<? super K, ? super V> var1);

    public KStream<K, V> peek(ForeachAction<? super K, ? super V> var1, Named var2);

    public BranchedKStream<K, V> split();

    public BranchedKStream<K, V> split(Named var1);

    public KStream<K, V> merge(KStream<K, V> var1);

    public KStream<K, V> merge(KStream<K, V> var1, Named var2);

    public KStream<K, V> repartition();

    public KStream<K, V> repartition(Repartitioned<K, V> var1);

    public void to(String var1);

    public void to(String var1, Produced<K, V> var2);

    public void to(TopicNameExtractor<K, V> var1);

    public void to(TopicNameExtractor<K, V> var1, Produced<K, V> var2);

    public KTable<K, V> toTable();

    public KTable<K, V> toTable(Named var1);

    public KTable<K, V> toTable(Materialized<K, V, KeyValueStore<Bytes, byte[]>> var1);

    public KTable<K, V> toTable(Named var1, Materialized<K, V, KeyValueStore<Bytes, byte[]>> var2);

    public KGroupedStream<K, V> groupByKey();

    public KGroupedStream<K, V> groupByKey(Grouped<K, V> var1);

    public <KOut> KGroupedStream<KOut, V> groupBy(KeyValueMapper<? super K, ? super V, KOut> var1);

    public <KOut> KGroupedStream<KOut, V> groupBy(KeyValueMapper<? super K, ? super V, KOut> var1, Grouped<KOut, V> var2);

    public <VRight, VOut> KStream<K, VOut> join(KStream<K, VRight> var1, ValueJoiner<? super V, ? super VRight, ? extends VOut> var2, JoinWindows var3);

    public <VRight, VOut> KStream<K, VOut> join(KStream<K, VRight> var1, ValueJoinerWithKey<? super K, ? super V, ? super VRight, ? extends VOut> var2, JoinWindows var3);

    public <VRight, VOut> KStream<K, VOut> join(KStream<K, VRight> var1, ValueJoiner<? super V, ? super VRight, ? extends VOut> var2, JoinWindows var3, StreamJoined<K, V, VRight> var4);

    public <VRight, VOut> KStream<K, VOut> join(KStream<K, VRight> var1, ValueJoinerWithKey<? super K, ? super V, ? super VRight, ? extends VOut> var2, JoinWindows var3, StreamJoined<K, V, VRight> var4);

    public <VRight, VOut> KStream<K, VOut> leftJoin(KStream<K, VRight> var1, ValueJoiner<? super V, ? super VRight, ? extends VOut> var2, JoinWindows var3);

    public <VRight, VOut> KStream<K, VOut> leftJoin(KStream<K, VRight> var1, ValueJoinerWithKey<? super K, ? super V, ? super VRight, ? extends VOut> var2, JoinWindows var3);

    public <VRight, VOut> KStream<K, VOut> leftJoin(KStream<K, VRight> var1, ValueJoiner<? super V, ? super VRight, ? extends VOut> var2, JoinWindows var3, StreamJoined<K, V, VRight> var4);

    public <VRight, VOut> KStream<K, VOut> leftJoin(KStream<K, VRight> var1, ValueJoinerWithKey<? super K, ? super V, ? super VRight, ? extends VOut> var2, JoinWindows var3, StreamJoined<K, V, VRight> var4);

    public <VRight, VOut> KStream<K, VOut> outerJoin(KStream<K, VRight> var1, ValueJoiner<? super V, ? super VRight, ? extends VOut> var2, JoinWindows var3);

    public <VRight, VOut> KStream<K, VOut> outerJoin(KStream<K, VRight> var1, ValueJoinerWithKey<? super K, ? super V, ? super VRight, ? extends VOut> var2, JoinWindows var3);

    public <VRight, VOut> KStream<K, VOut> outerJoin(KStream<K, VRight> var1, ValueJoiner<? super V, ? super VRight, ? extends VOut> var2, JoinWindows var3, StreamJoined<K, V, VRight> var4);

    public <VRight, VOut> KStream<K, VOut> outerJoin(KStream<K, VRight> var1, ValueJoinerWithKey<? super K, ? super V, ? super VRight, ? extends VOut> var2, JoinWindows var3, StreamJoined<K, V, VRight> var4);

    public <TableValue, VOut> KStream<K, VOut> join(KTable<K, TableValue> var1, ValueJoiner<? super V, ? super TableValue, ? extends VOut> var2);

    public <TableValue, VOut> KStream<K, VOut> join(KTable<K, TableValue> var1, ValueJoinerWithKey<? super K, ? super V, ? super TableValue, ? extends VOut> var2);

    public <TableValue, VOut> KStream<K, VOut> join(KTable<K, TableValue> var1, ValueJoiner<? super V, ? super TableValue, ? extends VOut> var2, Joined<K, V, TableValue> var3);

    public <TableValue, VOut> KStream<K, VOut> join(KTable<K, TableValue> var1, ValueJoinerWithKey<? super K, ? super V, ? super TableValue, ? extends VOut> var2, Joined<K, V, TableValue> var3);

    public <VTable, VOut> KStream<K, VOut> leftJoin(KTable<K, VTable> var1, ValueJoiner<? super V, ? super VTable, ? extends VOut> var2);

    public <VTable, VOut> KStream<K, VOut> leftJoin(KTable<K, VTable> var1, ValueJoinerWithKey<? super K, ? super V, ? super VTable, ? extends VOut> var2);

    public <VTable, VOut> KStream<K, VOut> leftJoin(KTable<K, VTable> var1, ValueJoiner<? super V, ? super VTable, ? extends VOut> var2, Joined<K, V, VTable> var3);

    public <VTable, VOut> KStream<K, VOut> leftJoin(KTable<K, VTable> var1, ValueJoinerWithKey<? super K, ? super V, ? super VTable, ? extends VOut> var2, Joined<K, V, VTable> var3);

    public <GlobalKey, GlobalValue, VOut> KStream<K, VOut> join(GlobalKTable<GlobalKey, GlobalValue> var1, KeyValueMapper<? super K, ? super V, ? extends GlobalKey> var2, ValueJoiner<? super V, ? super GlobalValue, ? extends VOut> var3);

    public <GlobalKey, GlobalValue, VOut> KStream<K, VOut> join(GlobalKTable<GlobalKey, GlobalValue> var1, KeyValueMapper<? super K, ? super V, ? extends GlobalKey> var2, ValueJoinerWithKey<? super K, ? super V, ? super GlobalValue, ? extends VOut> var3);

    public <GlobalKey, GlobalValue, VOut> KStream<K, VOut> join(GlobalKTable<GlobalKey, GlobalValue> var1, KeyValueMapper<? super K, ? super V, ? extends GlobalKey> var2, ValueJoiner<? super V, ? super GlobalValue, ? extends VOut> var3, Named var4);

    public <GlobalKey, GlobalValue, VOut> KStream<K, VOut> join(GlobalKTable<GlobalKey, GlobalValue> var1, KeyValueMapper<? super K, ? super V, ? extends GlobalKey> var2, ValueJoinerWithKey<? super K, ? super V, ? super GlobalValue, ? extends VOut> var3, Named var4);

    public <GlobalKey, GlobalValue, VOut> KStream<K, VOut> leftJoin(GlobalKTable<GlobalKey, GlobalValue> var1, KeyValueMapper<? super K, ? super V, ? extends GlobalKey> var2, ValueJoiner<? super V, ? super GlobalValue, ? extends VOut> var3);

    public <GlobalKey, GlobalValue, VOut> KStream<K, VOut> leftJoin(GlobalKTable<GlobalKey, GlobalValue> var1, KeyValueMapper<? super K, ? super V, ? extends GlobalKey> var2, ValueJoinerWithKey<? super K, ? super V, ? super GlobalValue, ? extends VOut> var3);

    public <GlobalKey, GlobalValue, VOut> KStream<K, VOut> leftJoin(GlobalKTable<GlobalKey, GlobalValue> var1, KeyValueMapper<? super K, ? super V, ? extends GlobalKey> var2, ValueJoiner<? super V, ? super GlobalValue, ? extends VOut> var3, Named var4);

    public <GlobalKey, GlobalValue, VOut> KStream<K, VOut> leftJoin(GlobalKTable<GlobalKey, GlobalValue> var1, KeyValueMapper<? super K, ? super V, ? extends GlobalKey> var2, ValueJoinerWithKey<? super K, ? super V, ? super GlobalValue, ? extends VOut> var3, Named var4);

    public <KOut, VOut> KStream<KOut, VOut> process(ProcessorSupplier<? super K, ? super V, ? extends KOut, ? extends VOut> var1, String ... var2);

    public <KOut, VOut> KStream<KOut, VOut> process(ProcessorSupplier<? super K, ? super V, ? extends KOut, ? extends VOut> var1, Named var2, String ... var3);

    public <VOut> KStream<K, VOut> processValues(FixedKeyProcessorSupplier<? super K, ? super V, ? extends VOut> var1, String ... var2);

    public <VOut> KStream<K, VOut> processValues(FixedKeyProcessorSupplier<? super K, ? super V, ? extends VOut> var1, Named var2, String ... var3);
}

