/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.List;
import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.streams.processor.api.ContextualProcessor;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorSupplier;
import org.apache.kafka.streams.processor.api.Record;

class KStreamBranch<K, V>
implements ProcessorSupplier<K, V, K, V> {
    private final List<Predicate<? super K, ? super V>> predicates;
    private final List<String> childNodes;

    KStreamBranch(List<Predicate<? super K, ? super V>> predicates, List<String> childNodes) {
        this.predicates = predicates;
        this.childNodes = childNodes;
    }

    @Override
    public Processor<K, V, K, V> get() {
        return new KStreamBranchProcessor();
    }

    private class KStreamBranchProcessor
    extends ContextualProcessor<K, V, K, V> {
        private KStreamBranchProcessor() {
        }

        @Override
        public void process(Record<K, V> record) {
            for (int i = 0; i < KStreamBranch.this.predicates.size(); ++i) {
                if (!KStreamBranch.this.predicates.get(i).test(record.key(), record.value())) continue;
                this.context().forward(record, KStreamBranch.this.childNodes.get(i));
                return;
            }
            if (KStreamBranch.this.childNodes.size() > KStreamBranch.this.predicates.size()) {
                this.context().forward(record, KStreamBranch.this.childNodes.get(KStreamBranch.this.predicates.size()));
            }
        }
    }
}

