/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.internals.KeyValueStoreWrapper;

public class KTableSourceValueGetterSupplier<K, V>
implements KTableValueGetterSupplier<K, V> {
    private final String storeName;

    public KTableSourceValueGetterSupplier(String storeName) {
        this.storeName = storeName;
    }

    @Override
    public KTableValueGetter<K, V> get() {
        return new KTableSourceValueGetter();
    }

    @Override
    public String[] storeNames() {
        return new String[]{this.storeName};
    }

    private class KTableSourceValueGetter
    implements KTableValueGetter<K, V> {
        private KeyValueStoreWrapper<K, V> store;

        private KTableSourceValueGetter() {
        }

        @Override
        public void init(ProcessorContext<?, ?> context) {
            this.store = new KeyValueStoreWrapper(context, KTableSourceValueGetterSupplier.this.storeName);
        }

        @Override
        public ValueAndTimestamp<V> get(K key) {
            return this.store.get(key);
        }

        @Override
        public ValueAndTimestamp<V> get(K key, long asOfTimestamp) {
            return this.store.get(key, asOfTimestamp);
        }

        @Override
        public boolean isVersioned() {
            return this.store.isVersionedStore();
        }
    }
}

