/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.query;

import java.util.Optional;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.streams.query.Query;
import org.apache.kafka.streams.query.ResultOrder;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.ValueAndTimestamp;

@InterfaceStability.Evolving
public final class TimestampedRangeQuery<K, V>
implements Query<KeyValueIterator<K, ValueAndTimestamp<V>>> {
    private final Optional<K> lower;
    private final Optional<K> upper;
    private final ResultOrder order;

    private TimestampedRangeQuery(Optional<K> lower, Optional<K> upper, ResultOrder order) {
        this.lower = lower;
        this.upper = upper;
        this.order = order;
    }

    public static <K, V> TimestampedRangeQuery<K, V> withRange(K lower, K upper) {
        return new TimestampedRangeQuery<K, V>(Optional.ofNullable(lower), Optional.ofNullable(upper), ResultOrder.ANY);
    }

    public static <K, V> TimestampedRangeQuery<K, V> withUpperBound(K upper) {
        return new TimestampedRangeQuery(Optional.empty(), Optional.of(upper), ResultOrder.ANY);
    }

    public static <K, V> TimestampedRangeQuery<K, V> withLowerBound(K lower) {
        return new TimestampedRangeQuery<K, V>(Optional.of(lower), Optional.empty(), ResultOrder.ANY);
    }

    public ResultOrder resultOrder() {
        return this.order;
    }

    public TimestampedRangeQuery<K, V> withDescendingKeys() {
        return new TimestampedRangeQuery<K, V>(this.lower, this.upper, ResultOrder.DESCENDING);
    }

    public TimestampedRangeQuery<K, V> withAscendingKeys() {
        return new TimestampedRangeQuery<K, V>(this.lower, this.upper, ResultOrder.ASCENDING);
    }

    public static <K, V> TimestampedRangeQuery<K, V> withNoBounds() {
        return new TimestampedRangeQuery(Optional.empty(), Optional.empty(), ResultOrder.ANY);
    }

    public Optional<K> lowerBound() {
        return this.lower;
    }

    public Optional<K> upperBound() {
        return this.upper;
    }
}

