/*
 * Decompiled with CFR 0.152.
 */
package org.pcollections;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import org.pcollections.AbstractUnmodifiableSet;
import org.pcollections.Empty;
import org.pcollections.PMap;
import org.pcollections.PSet;
import org.pcollections.PSortedMap;

public class OrderedPSet<E>
extends AbstractUnmodifiableSet<E>
implements PSet<E>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final OrderedPSet<Object> EMPTY = new OrderedPSet(Empty.map(), Empty.sortedMap());
    private final PMap<E, Long> ids;
    private final PSortedMap<Long, E> elements;

    public static <E> OrderedPSet<E> empty() {
        return EMPTY;
    }

    public static <E> OrderedPSet<E> from(Collection<? extends E> list) {
        if (list instanceof OrderedPSet) {
            return (OrderedPSet)list;
        }
        return OrderedPSet.empty().plusAll((Collection)list);
    }

    public static <E> OrderedPSet<E> singleton(E e) {
        return OrderedPSet.empty().plus((Object)e);
    }

    private OrderedPSet(PMap<E, Long> ids, PSortedMap<Long, E> elements) {
        this.ids = Objects.requireNonNull(ids, "ids is null");
        this.elements = Objects.requireNonNull(elements, "elements is null");
    }

    @Override
    public OrderedPSet<E> plus(E e) {
        if (this.ids.containsKey(e)) {
            return this;
        }
        Long id = this.elements.isEmpty() ? Long.MIN_VALUE : (Long)this.elements.lastKey() + 1L;
        return new OrderedPSet<E>(this.ids.plus(e, id), this.elements.plus((Object)id, e));
    }

    @Override
    public OrderedPSet<E> plusAll(Collection<? extends E> list) {
        PSet<E> s = this;
        for (E e : list) {
            s = s.plus((Object)e);
        }
        return s;
    }

    @Override
    public OrderedPSet<E> minus(Object e) {
        Long id = (Long)this.ids.get(e);
        if (id == null) {
            return this;
        }
        return new OrderedPSet<E>(this.ids.minus(e), this.elements.minus(id));
    }

    @Override
    public OrderedPSet<E> minusAll(Collection<?> list) {
        PSet<E> s = this;
        for (Object e : list) {
            s = s.minus(e);
        }
        return s;
    }

    @Override
    public OrderedPSet<E> intersect(Collection<? extends E> list) {
        return this.minusAll((Collection)this.minusAll((Collection)list));
    }

    @Override
    public Iterator<E> iterator() {
        return this.elements.values().iterator();
    }

    @Override
    public int size() {
        return this.ids.size();
    }
}

