/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.modern;

import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.group.modern.MemberState;

public abstract class ModernGroupMember {
    protected String memberId;
    protected int memberEpoch;
    protected int previousMemberEpoch;
    protected MemberState state;
    protected String instanceId;
    protected String rackId;
    protected String clientId;
    protected String clientHost;
    protected Set<String> subscribedTopicNames;
    protected Map<Uuid, Set<Integer>> assignedPartitions;

    protected ModernGroupMember(String memberId, int memberEpoch, int previousMemberEpoch, String instanceId, String rackId, String clientId, String clientHost, Set<String> subscribedTopicNames, MemberState state, Map<Uuid, Set<Integer>> assignedPartitions) {
        this.memberId = memberId;
        this.memberEpoch = memberEpoch;
        this.previousMemberEpoch = previousMemberEpoch;
        this.state = state;
        this.instanceId = instanceId;
        this.rackId = rackId;
        this.clientId = clientId;
        this.clientHost = clientHost;
        this.subscribedTopicNames = subscribedTopicNames;
        this.assignedPartitions = assignedPartitions;
    }

    public String memberId() {
        return this.memberId;
    }

    public int memberEpoch() {
        return this.memberEpoch;
    }

    public int previousMemberEpoch() {
        return this.previousMemberEpoch;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String rackId() {
        return this.rackId;
    }

    public String clientId() {
        return this.clientId;
    }

    public String clientHost() {
        return this.clientHost;
    }

    public Set<String> subscribedTopicNames() {
        return this.subscribedTopicNames;
    }

    public MemberState state() {
        return this.state;
    }

    public boolean isReconciledTo(int targetAssignmentEpoch) {
        return this.state == MemberState.STABLE && this.memberEpoch == targetAssignmentEpoch;
    }

    public Map<Uuid, Set<Integer>> assignedPartitions() {
        return this.assignedPartitions;
    }

    public static boolean hasAssignedPartitionsChanged(ModernGroupMember member1, ModernGroupMember member2) {
        return !member1.assignedPartitions().equals(member2.assignedPartitions());
    }
}

