/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.argparse4j.impl.type;

import java.io.File;
import java.io.IOException;
import net.sourceforge.argparse4j.helper.TextHelper;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.ArgumentType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileArgumentType
implements ArgumentType<File> {
    private boolean acceptSystemIn = false;
    private boolean verifyExists = false;
    private boolean verifyNotExists = false;
    private boolean verifyIsFile = false;
    private boolean verifyIsDirectory = false;
    private boolean verifyCanRead = false;
    private boolean verifyCanWrite = false;
    private boolean verifyCanWriteParent = false;
    private boolean verifyCanCreate = false;
    private boolean verifyCanExecute = false;
    private boolean verifyIsAbsolute = false;

    public FileArgumentType acceptSystemIn() {
        this.acceptSystemIn = true;
        return this;
    }

    public FileArgumentType verifyExists() {
        this.verifyExists = true;
        return this;
    }

    public FileArgumentType verifyNotExists() {
        this.verifyNotExists = true;
        return this;
    }

    public FileArgumentType verifyIsFile() {
        this.verifyIsFile = true;
        return this;
    }

    public FileArgumentType verifyIsDirectory() {
        this.verifyIsDirectory = true;
        return this;
    }

    public FileArgumentType verifyCanRead() {
        this.verifyCanRead = true;
        return this;
    }

    public FileArgumentType verifyCanWrite() {
        this.verifyCanWrite = true;
        return this;
    }

    public FileArgumentType verifyCanWriteParent() {
        this.verifyCanWriteParent = true;
        return this;
    }

    public FileArgumentType verifyCanCreate() {
        this.verifyCanCreate = true;
        return this;
    }

    public FileArgumentType verifyCanExecute() {
        this.verifyCanExecute = true;
        return this;
    }

    public FileArgumentType verifyIsAbsolute() {
        this.verifyIsAbsolute = true;
        return this;
    }

    @Override
    public File convert(ArgumentParser parser, Argument arg, String value) throws ArgumentParserException {
        File file = new File(value);
        if (this.verifyIsAbsolute && !this.isSystemIn(file)) {
            this.verifyIsAbsolute(parser, arg, file);
        }
        if (this.verifyExists && !this.isSystemIn(file)) {
            this.verifyExists(parser, arg, file);
        }
        if (this.verifyNotExists && !this.isSystemIn(file)) {
            this.verifyNotExists(parser, arg, file);
        }
        if (this.verifyIsFile && !this.isSystemIn(file)) {
            this.verifyIsFile(parser, arg, file);
        }
        if (this.verifyIsDirectory && !this.isSystemIn(file)) {
            this.verifyIsDirectory(parser, arg, file);
        }
        if (this.verifyCanRead && !this.isSystemIn(file)) {
            this.verifyCanRead(parser, arg, file);
        }
        if (this.verifyCanWrite && !this.isSystemIn(file)) {
            this.verifyCanWrite(parser, arg, file);
        }
        if (this.verifyCanWriteParent && !this.isSystemIn(file)) {
            this.verifyCanWriteParent(parser, arg, file);
        }
        if (this.verifyCanCreate && !this.isSystemIn(file)) {
            this.verifyCanCreate(parser, arg, file);
        }
        if (this.verifyCanExecute && !this.isSystemIn(file)) {
            this.verifyCanExecute(parser, arg, file);
        }
        return file;
    }

    private void verifyExists(ArgumentParser parser, Argument arg, File file) throws ArgumentParserException {
        if (!file.exists()) {
            throw new ArgumentParserException(String.format(TextHelper.LOCALE_ROOT, "File not found: '%s'", file), parser, arg);
        }
    }

    private void verifyNotExists(ArgumentParser parser, Argument arg, File file) throws ArgumentParserException {
        if (file.exists()) {
            throw new ArgumentParserException(String.format(TextHelper.LOCALE_ROOT, "File found: '%s'", file), parser, arg);
        }
    }

    private void verifyIsFile(ArgumentParser parser, Argument arg, File file) throws ArgumentParserException {
        if (!file.isFile()) {
            throw new ArgumentParserException(String.format(TextHelper.LOCALE_ROOT, "Not a file: '%s'", file), parser, arg);
        }
    }

    private void verifyIsDirectory(ArgumentParser parser, Argument arg, File file) throws ArgumentParserException {
        if (!file.isDirectory()) {
            throw new ArgumentParserException(String.format(TextHelper.LOCALE_ROOT, "Not a directory: '%s'", file), parser, arg);
        }
    }

    private void verifyCanRead(ArgumentParser parser, Argument arg, File file) throws ArgumentParserException {
        if (!file.canRead()) {
            throw new ArgumentParserException(String.format(TextHelper.LOCALE_ROOT, "Insufficient permissions to read file: '%s'", file), parser, arg);
        }
    }

    private void verifyCanWrite(ArgumentParser parser, Argument arg, File file) throws ArgumentParserException {
        if (!file.canWrite()) {
            throw new ArgumentParserException(String.format(TextHelper.LOCALE_ROOT, "Insufficient permissions to write file: '%s'", file), parser, arg);
        }
    }

    private void verifyCanWriteParent(ArgumentParser parser, Argument arg, File file) throws ArgumentParserException {
        File parent = file.getParentFile();
        if (parent == null || !parent.canWrite()) {
            throw new ArgumentParserException(String.format(TextHelper.LOCALE_ROOT, "Cannot write parent of file: '%s'", file), parser, arg);
        }
    }

    private void verifyCanCreate(ArgumentParser parser, Argument arg, File file) throws ArgumentParserException {
        try {
            File parent = file.getCanonicalFile().getParentFile();
            if (parent != null && parent.canWrite()) {
                return;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw new ArgumentParserException(String.format(TextHelper.LOCALE_ROOT, "Cannot create file: '%s'", file), parser, arg);
    }

    private void verifyCanExecute(ArgumentParser parser, Argument arg, File file) throws ArgumentParserException {
        if (!file.canExecute()) {
            throw new ArgumentParserException(String.format(TextHelper.LOCALE_ROOT, "Insufficient permissions to execute file: '%s'", file), parser, arg);
        }
    }

    private void verifyIsAbsolute(ArgumentParser parser, Argument arg, File file) throws ArgumentParserException {
        if (!file.isAbsolute()) {
            throw new ArgumentParserException(String.format(TextHelper.LOCALE_ROOT, "Not an absolute file: '%s'", file), parser, arg);
        }
    }

    private boolean isSystemIn(File file) {
        return this.acceptSystemIn && file.getPath().equals("-");
    }
}

