/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jms.service.internal;

import javax.transaction.TransactionManager;
import org.ops4j.pax.jms.service.PooledConnectionFactoryFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTransactionManagerTracker<T>
extends ServiceTracker<T, ServiceRegistration<PooledConnectionFactoryFactory>> {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionManager.class);
    private ServiceReference<T> selectedService;

    public AbstractTransactionManagerTracker(BundleContext context, Class<T> clazz) throws InvalidSyntaxException {
        this(context, clazz, null);
    }

    public AbstractTransactionManagerTracker(BundleContext context, Class<T> clazz, String filter) throws InvalidSyntaxException {
        super(context, context.createFilter(filter == null ? "(objectClass=" + clazz.getName() + ")" : "(&(objectClass=" + clazz.getName() + ")" + filter + ")"), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceRegistration<PooledConnectionFactoryFactory> addingService(ServiceReference<T> reference) {
        AbstractTransactionManagerTracker abstractTransactionManagerTracker = this;
        synchronized (abstractTransactionManagerTracker) {
            if (this.selectedService != null) {
                LOG.warn("There is more than one TransactionManager service. Ignoring this one");
                return null;
            }
            this.selectedService = reference;
        }
        LOG.info("TransactionManager service detected. Providing support for XA ConnectionFactoryFactories");
        Object tm = this.context.getService(reference);
        return this.createService(this.context, tm);
    }

    public void modifiedService(ServiceReference<T> reference, ServiceRegistration<PooledConnectionFactoryFactory> sreg) {
        LOG.info("TransactionManager service modified");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference<T> reference, ServiceRegistration<PooledConnectionFactoryFactory> sreg) {
        AbstractTransactionManagerTracker abstractTransactionManagerTracker = this;
        synchronized (abstractTransactionManagerTracker) {
            if (this.selectedService == null || !this.selectedService.equals(reference)) {
                return;
            }
            this.selectedService = null;
        }
        LOG.info("TransactionManager service lost. Shutting down support for XA ConnectionFactoryFactories");
        sreg.unregister();
        this.context.ungetService(reference);
    }

    public abstract ServiceRegistration<PooledConnectionFactoryFactory> createService(BundleContext var1, T var2);
}

