/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiCommand;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A list of commands. <p> This list is returned whenever commands are issued in bulk, and contains a second list with information about errors issuing specific commands.")
public class ApiBulkCommandList {
    @SerializedName(value="items")
    private List<ApiCommand> items = null;
    @SerializedName(value="errors")
    private List<String> errors = null;

    public ApiBulkCommandList items(List<ApiCommand> items) {
        this.items = items;
        return this;
    }

    public ApiBulkCommandList addItemsItem(ApiCommand itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<ApiCommand>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<ApiCommand> getItems() {
        return this.items;
    }

    public void setItems(List<ApiCommand> items) {
        this.items = items;
    }

    public ApiBulkCommandList errors(List<String> errors) {
        this.errors = errors;
        return this;
    }

    public ApiBulkCommandList addErrorsItem(String errorsItem) {
        if (this.errors == null) {
            this.errors = new ArrayList<String>();
        }
        this.errors.add(errorsItem);
        return this;
    }

    @ApiModelProperty(value="Errors that occurred when issuing individual commands.")
    public List<String> getErrors() {
        return this.errors;
    }

    public void setErrors(List<String> errors) {
        this.errors = errors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiBulkCommandList apiBulkCommandList = (ApiBulkCommandList)o;
        return Objects.equals(this.items, apiBulkCommandList.items) && Objects.equals(this.errors, apiBulkCommandList.errors);
    }

    public int hashCode() {
        return Objects.hash(this.items, this.errors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiBulkCommandList {\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

