/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Arguments used for enable Llama RM command.")
public class ApiEnableLlamaRmArguments {
    @SerializedName(value="llama1HostId")
    private String llama1HostId = null;
    @SerializedName(value="llama1RoleName")
    private String llama1RoleName = null;
    @SerializedName(value="llama2HostId")
    private String llama2HostId = null;
    @SerializedName(value="llama2RoleName")
    private String llama2RoleName = null;
    @SerializedName(value="zkServiceName")
    private String zkServiceName = null;
    @SerializedName(value="skipRestart")
    private Boolean skipRestart = null;

    public ApiEnableLlamaRmArguments llama1HostId(String llama1HostId) {
        this.llama1HostId = llama1HostId;
        return this;
    }

    @ApiModelProperty(value="HostId of the host on which the first Llama role will be created.")
    public String getLlama1HostId() {
        return this.llama1HostId;
    }

    public void setLlama1HostId(String llama1HostId) {
        this.llama1HostId = llama1HostId;
    }

    public ApiEnableLlamaRmArguments llama1RoleName(String llama1RoleName) {
        this.llama1RoleName = llama1RoleName;
        return this;
    }

    @ApiModelProperty(value="Name of the first Llama role to be created (optional).")
    public String getLlama1RoleName() {
        return this.llama1RoleName;
    }

    public void setLlama1RoleName(String llama1RoleName) {
        this.llama1RoleName = llama1RoleName;
    }

    public ApiEnableLlamaRmArguments llama2HostId(String llama2HostId) {
        this.llama2HostId = llama2HostId;
        return this;
    }

    @ApiModelProperty(value="HostId of the host on which the second Llama role will be created.")
    public String getLlama2HostId() {
        return this.llama2HostId;
    }

    public void setLlama2HostId(String llama2HostId) {
        this.llama2HostId = llama2HostId;
    }

    public ApiEnableLlamaRmArguments llama2RoleName(String llama2RoleName) {
        this.llama2RoleName = llama2RoleName;
        return this;
    }

    @ApiModelProperty(value="Name of the second Llama role to be created (optional).")
    public String getLlama2RoleName() {
        return this.llama2RoleName;
    }

    public void setLlama2RoleName(String llama2RoleName) {
        this.llama2RoleName = llama2RoleName;
    }

    public ApiEnableLlamaRmArguments zkServiceName(String zkServiceName) {
        this.zkServiceName = zkServiceName;
        return this;
    }

    @ApiModelProperty(value="Name of the ZooKeeper service that will be used for auto-failover. Only relevant when enabling Llama RM in HA mode (i.e., when two Llama roles are being created). This argument may be omitted if the ZooKeeper dependency for Impala is already configured.")
    public String getZkServiceName() {
        return this.zkServiceName;
    }

    public void setZkServiceName(String zkServiceName) {
        this.zkServiceName = zkServiceName;
    }

    public ApiEnableLlamaRmArguments skipRestart(Boolean skipRestart) {
        this.skipRestart = skipRestart;
        return this;
    }

    @ApiModelProperty(required=true, value="Skip the restart of Yarn, Impala, and their dependent services, and don't deploy client configuration. Default is false (i.e., by default, the services are restarted and client configuration is deployed).")
    public Boolean getSkipRestart() {
        return this.skipRestart;
    }

    public void setSkipRestart(Boolean skipRestart) {
        this.skipRestart = skipRestart;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiEnableLlamaRmArguments apiEnableLlamaRmArguments = (ApiEnableLlamaRmArguments)o;
        return Objects.equals(this.llama1HostId, apiEnableLlamaRmArguments.llama1HostId) && Objects.equals(this.llama1RoleName, apiEnableLlamaRmArguments.llama1RoleName) && Objects.equals(this.llama2HostId, apiEnableLlamaRmArguments.llama2HostId) && Objects.equals(this.llama2RoleName, apiEnableLlamaRmArguments.llama2RoleName) && Objects.equals(this.zkServiceName, apiEnableLlamaRmArguments.zkServiceName) && Objects.equals(this.skipRestart, apiEnableLlamaRmArguments.skipRestart);
    }

    public int hashCode() {
        return Objects.hash(this.llama1HostId, this.llama1RoleName, this.llama2HostId, this.llama2RoleName, this.zkServiceName, this.skipRestart);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiEnableLlamaRmArguments {\n");
        sb.append("    llama1HostId: ").append(this.toIndentedString(this.llama1HostId)).append("\n");
        sb.append("    llama1RoleName: ").append(this.toIndentedString(this.llama1RoleName)).append("\n");
        sb.append("    llama2HostId: ").append(this.toIndentedString(this.llama2HostId)).append("\n");
        sb.append("    llama2RoleName: ").append(this.toIndentedString(this.llama2RoleName)).append("\n");
        sb.append("    zkServiceName: ").append(this.toIndentedString(this.zkServiceName)).append("\n");
        sb.append("    skipRestart: ").append(this.toIndentedString(this.skipRestart)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

