/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Encapsulates information needed to utilize the s3 Gateway API- namely, the AWS credentials, the rest url of the s3 Gateway and the S3 bucket.")
public class ApiOzoneS3GatewayInfo {
    @SerializedName(value="awsAccessKey")
    private String awsAccessKey = null;
    @SerializedName(value="awsSecret")
    private String awsSecret = null;
    @SerializedName(value="restUrl")
    private String restUrl = null;
    @SerializedName(value="bucket")
    private String bucket = null;

    public ApiOzoneS3GatewayInfo awsAccessKey(String awsAccessKey) {
        this.awsAccessKey = awsAccessKey;
        return this;
    }

    @ApiModelProperty(value="The AWS access key for a particular Ozone service")
    public String getAwsAccessKey() {
        return this.awsAccessKey;
    }

    public void setAwsAccessKey(String awsAccessKey) {
        this.awsAccessKey = awsAccessKey;
    }

    public ApiOzoneS3GatewayInfo awsSecret(String awsSecret) {
        this.awsSecret = awsSecret;
        return this;
    }

    @ApiModelProperty(value="The AWS secret associated with the access key")
    public String getAwsSecret() {
        return this.awsSecret;
    }

    public void setAwsSecret(String awsSecret) {
        this.awsSecret = awsSecret;
    }

    public ApiOzoneS3GatewayInfo restUrl(String restUrl) {
        this.restUrl = restUrl;
        return this;
    }

    @ApiModelProperty(value="The rest url, in host:port format, of the Ozone S3 Gateway")
    public String getRestUrl() {
        return this.restUrl;
    }

    public void setRestUrl(String restUrl) {
        this.restUrl = restUrl;
    }

    public ApiOzoneS3GatewayInfo bucket(String bucket) {
        this.bucket = bucket;
        return this;
    }

    @ApiModelProperty(value="The Ozone address of the created S3 bucket")
    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiOzoneS3GatewayInfo apiOzoneS3GatewayInfo = (ApiOzoneS3GatewayInfo)o;
        return Objects.equals(this.awsAccessKey, apiOzoneS3GatewayInfo.awsAccessKey) && Objects.equals(this.awsSecret, apiOzoneS3GatewayInfo.awsSecret) && Objects.equals(this.restUrl, apiOzoneS3GatewayInfo.restUrl) && Objects.equals(this.bucket, apiOzoneS3GatewayInfo.bucket);
    }

    public int hashCode() {
        return Objects.hash(this.awsAccessKey, this.awsSecret, this.restUrl, this.bucket);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiOzoneS3GatewayInfo {\n");
        sb.append("    awsAccessKey: ").append(this.toIndentedString(this.awsAccessKey)).append("\n");
        sb.append("    awsSecret: ").append(this.toIndentedString(this.awsSecret)).append("\n");
        sb.append("    restUrl: ").append(this.toIndentedString(this.restUrl)).append("\n");
        sb.append("    bucket: ").append(this.toIndentedString(this.bucket)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

