/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.builder;

import java.util.ArrayList;
import java.util.List;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.GatewayResources;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.i18n.resources.ResourcesFactory;
import org.apache.knox.gateway.topology.Topology;
import org.apache.knox.gateway.topology.builder.TopologyBuilder;
import org.apache.knox.gateway.topology.builder.property.Property;
import org.apache.knox.gateway.topology.builder.property.interpreter.InterpretException;
import org.apache.knox.gateway.topology.builder.property.interpreter.PropertyInterpreter;

public class PropertyTopologyBuilder
implements TopologyBuilder {
    private static GatewayMessages log = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    private static GatewayResources gatewayResources = (GatewayResources)ResourcesFactory.get(GatewayResources.class);
    private List<Property> properties = new ArrayList<Property>();

    public PropertyTopologyBuilder addProperty(Property property) {
        this.properties.add(property);
        return this;
    }

    public List<Property> properties() {
        return this.properties;
    }

    public Topology build() {
        Topology topology = new Topology();
        PropertyInterpreter propertyInterpreter = new PropertyInterpreter(topology);
        for (Property property : this.properties) {
            try {
                propertyInterpreter.interpret(property.getName(), property.getValue());
            }
            catch (InterpretException ie) {
                log.failedToInterpretProperty(property.getName(), ie);
                throw new IllegalArgumentException(gatewayResources.wrongTopologyDataFormatError());
            }
        }
        return topology;
    }
}

